dnl @synopsis AC_SUBST_DIR(VARNAME, [DIR])
dnl
dnl This macro substitutes (with AC_SUBST) VARNAME with the expansion of
dnl itself or the DIR variable if specified, taking care of fixing up
dnl ${prefix} and such.
dnl
dnl Side effect: VARNAME is replaced with the expansion.
dnl
dnl AC_SUBST_DIR bases on Alexandre Oliva's AC_DEFINE_DIR macro.
dnl
dnl Examples:
dnl
dnl    AC_SUBST_DIR(DATADIR)
dnl
dnl @version $Id: ac_subst_dir.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.32 $
dnl @author Mathias Hasselmann <mathias.hasselmann@gmx.de>

AC_DEFUN([AC_SUBST_DIR], [
        ifelse($2, , $1, $1="[$]$2")
        $1=`(
            test "x$prefix" = xNONE && prefix="$ac_default_prefix"
            test "x$exec_prefix" = xNONE && exec_prefix="${prefix}"
            eval echo \""[$]$1"\"
        )`
        AC_SUBST($1)
])
