dnl @synopsis PETI_ENABLED_DYNAMIC_LINKING
dnl
dnl This macro give the user a comfortable way to add "-static" to the
dnl linker flags, that is, to build statically linked binaries.
dnl Currently only the "-static" flags is used to achieve that, but on
dnl some operating systems, more sophisticated LDFLAGS might be
dnl necessary.
dnl
dnl @author Peter Simons <simons@computer.org>
dnl @version $Id: peti_enable_dynamic_linking.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.32 $
dnl
AC_DEFUN([PETI_ENABLED_DYNAMIC_LINKING], [
AC_MSG_CHECKING(whether what binaries we shall create)
AC_ARG_ENABLE(dynamic-link,
[  --enable-dynamic-link   Create dynamically linked binaries (default)],
if test "$enableval" = "yes"; then
    AC_MSG_RESULT(dynamically linked)
else
    LDFLAGS="$LDFLAGS -static"
    AC_MSG_RESULT(statically linked)
fi,
AC_MSG_RESULT(dynamically linked))
])
