dnl @synopsis AC_PROTOTYPE_GETSOCKNAME
dnl
dnl Requires the AC_PROTOTYPE macro.
dnl
dnl Find the type of argument two and three of getsockname. User
dnl must include the following in acconfig.h:
dnl
dnl /* Type of second argument of getsockname */
dnl #undef GETSOCKNAME_ARG2
dnl
dnl /* Type of third argument of getsockname */
dnl #undef GETSOCKNAME_ARG3
dnl
dnl @version $Id: ac_prototype_getsockname.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.32 $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_PROTOTYPE_GETSOCKNAME],[
AC_PROTOTYPE(getsockname,
 [
  #include <sys/types.h>
  #include <sys/socket.h>
 ],
 [
  int a = 0;
  ARG2 * b = 0;
  ARG3 * c = 0;
  getsockname(a, b, c);
 ],
 ARG2, [struct sockaddr, void],
 ARG3, [socklen_t, size_t, int, unsigned int, long unsigned int])
])
