dnl @synopsis AC_CXX_TEMPLATE_OBJS
dnl
dnl This macro tries to find the place where the objects files resulting
dnl from templates instantiations are stored and the associated compiler
dnl flags. This is particularly useful to include these files in
dnl libraries. Currently only g++/egcs and SUN CC are supported (there is
dnl nothing to be done for the formers while the latter uses directory
dnl ./Templates.DB if you use the -ptr. flag). This macro sets the
dnl CXXFLAGS if needed, it also sets the output variable
dnl TEMPLATES_OBJ. Note that if you use libtool, this macro does work
dnl correctly with the SUN compilers ONLY while building static
dnl libraries. Since there are sometimes problems with exception handling
dnl with multiple levels of shared libraries even with g++ on this
dnl platform, you may wish to enforce the usage of static libraires
dnl there. You can do this by putting the following statements in your
dnl configure.in file:
dnl
dnl    AC_CANONICAL_HOST
dnl    case x$host_os in
dnl      xsolaris*) AC_DISABLE_SHARED ;;
dnl    esac
dnl    AM_PROG_LIBTOOL
dnl
dnl @version $Id: ac_cxx_template_objs.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.32 $
dnl @author Luc Maisonobe
dnl
AC_DEFUN([AC_CXX_TEMPLATE_OBJS],
[AC_CACHE_CHECK(where template objects are stored, ac_cv_cxx_templobjs,
 [ ac_cv_cxx_templobjs='unknown'
   if test "$GXX" = yes; then
     ac_cv_cxx_templobjs='nowhere'
   else
     case $CXX in
       CC|*/CC)
        cat > conftest.cc <<EOF
template<class T> class A { public : A () {} };
template<class T> void f (const A<T>&) {}
main()
{ A<double> d;
  A<int> i;
  f (d);
  f (i);
  return 0;
}
EOF
        if test "$ac_cv_cxx_templobjs" = 'unknown' ; then
          if test -d Templates.DB ; then
            rm -fr Templates.DB
          fi
          if $CXX $CXXFLAGS -ptr. -c conftest.cc 1> /dev/null 2>&1; then
            if test -d Templates.DB ; then
#             this should be Sun CC <= 4.2
              CXXFLAGS="$CXXFLAGS -ptr."
              if test x"$LIBTOOL" = x ; then
                ac_cv_cxx_templobjs='Templates.DB/*.o'
              else
                ac_cv_cxx_templobjs='Templates.DB/*.lo'
              fi
              rm -fr Templates.DB
            fi
          fi
        fi
        if test "$ac_cv_cxx_templobjs" = 'unknown' ; then
          if test -d SunWS_cache ; then
            rm -fr SunWS_cache
          fi
          if $CXX $CXXFLAGS -c conftest.cc 1> /dev/null 2>&1; then
            if test -d SunWS_cache ; then
#             this should be Sun WorkShop C++ compiler 5.x
#             or Sun Forte C++ compiler >= 6.x
              if test x"$LIBTOOL" = x ; then
                ac_cv_cxx_templobjs='SunWS_cache/*/*.o'
              else
                ac_cv_cxx_templobjs='SunWS_cache/*/*.lo'
              fi
              rm -fr SunWS_cache
            fi
          fi
        fi
        rm -f conftest* ;;
     esac
   fi
   case "x$ac_cv_cxx_templobjs" in
     xunknown|xnowhere)
     TEMPLATE_OBJS="" ;;
     *)
     TEMPLATE_OBJS="$ac_cv_cxx_templobjs" ;;
   esac
   AC_SUBST(TEMPLATE_OBJS)])])
