dnl @synopsis MS_PROG_PGCLIENT()
dnl
dnl This macro searches for a program called 'pgclient'.
dnl If found the variable $pgclient is set to its path.
dnl Else it is set to 0.
dnl An option is added to the configure script for setting an search path instead of $PATH ($pgclient_dir).
dnl If pgclient is necessary for installing your program, you can do something like
dnl the following to stop configure with an error if pgclient wasn't found:
dnl
dnl       if test "x$pgclient" = "x0"; then AC_MSG_ERROR([We need that to setup the database!]); fi
dnl
dnl pgclient can be found at http://pgclient.freesources.org
dnl
dnl @version $Id: ms_prog_pgclient.m4,v 1.1 2002/12/12 23:15 ac-archive-0.5.39 $
dnl @author Moritz Sinn <moritz@freesources.org>
dnl
AC_DEFUN([MS_PROG_PGCLIENT], [
AC_ARG_WITH(pgclient, [  --with-pgclient=DIR                    where to find pgclient (default: $PATH)], [pgclient_dir=$withval], [pgclient_dir=$PATH])
AC_PATH_PROG([pgclient], [pgclient], [0], $pgclient_dir)
])dnl
