dnl
dnl The AC_CFLAGS_WANT_NO_ macros do all have two arguments.
dnl The first flags the importance-level and the second an alternative shellvar
dnl and both can be omitted where the first will usually default to 0 or 1 or 2
dnl and the second to the advertised CFLAGS variable where it gets appended.
dnl
dnl All the importance-levels may be pushed as numeric or under a commmon
dnl name. "0" = "no" means disable (including warnings), "1" = "warn" means 
dnl let the compiler warn at the construct if the compiler can be told to
dnl do so, "2" = "yes" means let the compiler run in that mode if a modeswitch
dnl option is available, and "3" = "strict" means to error-out if the compiler
dnl does not support the given feature.
dnl
dnl The default for the second argument is CFLAGS (or CXXFLAGS for its cousin
dnl routines named AC_CXXFLAGS_WANT_) where the compiler-options are appended
dnl to but that can be overridden. Still, it will _append_ to that shell var.
dnl
dnl All WANT-names follow the long-options from gcc. Therefore, if you look
dnl into `gcc --help -v` then you will largely be able to guess the name
dnl of the macro as some -fvolatile-global option would map to a macro name
dnl of AC_CFLAGS_WANT_VOLATILE_GLOBAL. A lot of function however map to a
dnl name of _WANT_NO_ where the default would be to have the feature enabled,
dnl e.g. AC_CFLAGS_WANT_NO_LONG_LONG (for -fno-long-long), and in some of
dnl these case the disable-word is turned into a simple _NO_, so you will
dnl -fomit-framepointer as AC_CFLAGS_WANT_NO_FRAMEPOINTER. 
dnl
dnl Note that a lot of macros can in fact never be feature-enabled as they
dnl are just plain warning-levels. Where we have a bunch of AC_CFLAGS_WANT_
dnl and AC_CFLAGS_WANT_NO_ function, these do often have a cousin just
dnl named AC_CFLAGS_WARN_AT_ and AC_CFLAGS_NO_WARN_ respectivly.
dnl
dnl Even though the names are gcc-oriented you will find that quite some of
dnl the macros contain code parts that enable the option to be enabled or
dnl disabled for other compilers - especially the native compilers of some
dnl operating systems like hpux, irix, aix, solaris. That's what makes these
dnl macros so powerful - you do not have to tes $GCC = yes, and you do not
dnl have to handle the different versions of GCC (the gcc3 has moved a lot
dnl of backend options -malign to be general options -falign). On the
dnl downside there are vast number of options in this file since gcc has so
dnl many and most are still only gcc. That's largely just convenience style.
dnl
dnl (C) 2002 Guido Draheim, free license as of GNU autoconf.

dnl AC_CFLAGS_CHECK(levelignore, shellvar, optionname)
AC_DEFUN([AC_CFLAGS_CHECK],
[AC_CACHE_CHECK(whether ${CC-cc} accepts [$3], [$2],
[echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} -c $3 conftest.c 2>&1`"; then
  m4_if($2,,CFLAGS,$2)="[$]m4_if($2,,CFLAGS,$2) $3"
fi
rm -f conftest*
])])

AC_DEFUN([AC_CXXFLAGS_CHECK],
[AC_CACHE_CHECK(whether ${CXX-c++} accepts [$3], [$2],
[echo 'void f(){}' > conftest.c
if test -z "`${CXX-c++} -c $3 conftest.c 2>&1`"; then
  m4_if($2,,CXXFLAGS,$2)="[$]m4_if($2,,CXXFLAGS,$2) $3"
fi
rm -f conftest*
])])

dnl do nothing when level=no, default-level=yes
dnl AC_CFLAGS_DO_WANT(level, shellvar, optionname, option-no-name, default)
AC_DEFUN([AC_CFLAGS_DO_WANT],
[case "m4_if([$1],,[yes],[$1])" in
  m4_if([$5],,[0|no],[$5])) ;; # skip - assumed the default
  0|no) AC_CFLAGS_CHECK($1,$2,$4) ;;
  *) AC_CFLAGS_CHECK($1,$2,$3) ;;
esac])

dnl do nothing when level=yes, default-level=no
dnl AC_CFLAGS_WANT_NO(level, shellvar, default, optionname, option-no-name)
AC_DEFUN([AC_CFLAGS_WANT_NO],
[case "m4_if([$1],,[no],[$1])" in
  m4_if($5,,1|2|3|warn|yes|strict,$5)) ;; # skip - assumed the default
  0|no) AC_CFLAGS_CHECK($1,$2,$4) ;;
  *) AC_CFLAGS_CHECK($1,$2,$3) ;;
esac])


dnl do nothing when level=no, default-level=yes
dnl AC_CXXFLAGS_DO_WANT(level, shellvar, optionname, option-no-name, default)
AC_DEFUN([AC_CXXFLAGS_DO_WANT],
[case "m4_if([$1],,[yes],[$1])" in
  m4_if([$5],,[0|no],[$5])) ;; # skip - assumed the default
  0|no) AC_CXXFLAGS_CHECK($1,$2,$4) ;;
  *) AC_CXXFLAGS_CHECK($1,$2,$3) ;;
esac])

dnl do nothing when level=yes, default-level=no
dnl AC_CXXFLAGS_WANT_NO(level, shellvar, default, optionname, option-no-name)
AC_DEFUN([AC_CXXFLAGS_WANT_NO],
[case "m4_if([$1],,[no],[$1])" in
  m4_if($5,,1|2|3|warn|yes|strict,$5)) ;; # skip - assumed the default
  0|no) AC_CXXFLAGS_CHECK($1,$2,$4) ;;
  *) AC_CXXFLAGS_CHECK($1,$2,$3) ;;
esac])



dnl warn if trigraphs are encounted
AC_DEFUN([AC_CFLAGS_WARN_AT_TRIGRAPHS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wtrigraphs],[-Wno-trigraphs])])

AC_DEFUN([AC_CFLAGS_NO_WARN_TRIGRAPHS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wtrigraphs],[-Wno-trigraphs])])

dnl warn if one comment starts inside another
AC_DEFUN([AC_CFLAGS_WARN_AT_COMMENTS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wcomments],[-Wno-comments])])

AC_DEFUN([AC_CFLAGS_NO_WARN_COMMENTS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wcomments],[-Wno-comments])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_COMMENTS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wcomments],[-Wno-comments])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_COMMENTS],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wcomments],[-Wno-comments])])

dnl warn bout features not present in traditional C
AC_DEFUN([AC_CFLAGS_WARN_AT_TRADITIONAL],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wtraditional],[-Wno-traditional])])

AC_DEFUN([AC_CFLAGS_NO_WARN_TRADITIONAL],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wtraditional],[-Wno-traditional])])

dnl warn if an undefined macro is used by %:if
AC_DEFUN([AC_CFLAGS_WARN_AT_UNDEF],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wundef],[-Wno-undef])])

AC_DEFUN([AC_CFLAGS_NO_WARN_UNDEF],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wundef],[-Wno-undef])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_UNDEF],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wundef],[-Wno-undef])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_UNDEF],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wundef],[-Wno-undef])])

dnl suppress warnings from system headers
AC_DEFUN([AC_CFLAGS_NO_WARN_SYSTEM_HEADERS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wsystem-headers],[-Wno-system-headers])])

AC_DEFUN([AC_CFLAGS_WARN_AT_SYSTEM_HEADERS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wsystem-headers],[-Wno-system-headers])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_SYSTEM_HEADERS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wsystem-headers],[-Wno-system-headers])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_SYSTEM_HEADERS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wsystem-headers],[-Wno-system-headers])])

dnl combined warnings
AC_DEFUN([AC_CFLAGS_WARN_ALL],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wall])])

AC_DEFUN([AC_CFLAGS_WARN_EXTRA],
[AC_CFLAGS_DO_WANT([$1],[$2],[-W])])

AC_DEFUN([AC_CXXFLAGS_WARN_ALL],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wall])])

AC_DEFUN([AC_CXXFLAGS_WARN_EXTRA],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-W])])

dnl report on permanent memory allocation at end of run
AC_DEFUN([AC_CFLAGS_WANT_MEM_REPORT],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fmem-report])])

AC_DEFUN([AC_CXXFLAGS_WANT_MEM_REPORT],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fmem-report])])

dnl report time taken by each compiler pass at end of run
AC_DEFUN([AC_CFLAGS_WANT_TIME_REPORT],
[AC_CFLAGS_DO_WANT([$1],[$2],[-ftime-report])])

AC_DEFUN([AC_CXXFLAGS_WANT_TIME_REPORT],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-ftime-report])])

dnl convert floting point constant to single precision constant
AC_DEFUN([AC_CFLAGS_WANT_SINGLE_PRECISION_CONSTANT],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fsingle-precision-constant])])

AC_DEFUN([AC_CXXFLAGS_WANT_SINGLE_PRECISION_CONSTANT],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fsingle-precision-constant])])

dnl generate code to check bounds before dereferencing pointers and arrays
AC_DEFUN([AC_CFLAGS_WANT_BOUNDS_CHECK],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fbounds-check])])

AC_DEFUN([AC_CXXFLAGS_WANT_BOUNDS_CHECK],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fbounds-check])])

dnl compile pointers as triples: value, base and end
AC_DEFUN([AC_CFLAGS_WANT_BOUNDED_POINTERS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fbounded-pointers])])

AC_DEFUN([AC_CXXFLAGS_WANT_BOUNDED_POINTERS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fbounded-pointers])])

dnl allow math optimizations that may violate IEEE or ANSI standards
AC_DEFUN([AC_CFLAGS_WANT_UNSAFE_MATH_OPTIMIZATIONS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-funsafe-math-optimizations])])

AC_DEFUN([AC_CXXFLAGS_WANT_UNSAFE_MATH_OPTIMIZATIONS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-funsafe-math-optimizations])])

dnl floating-point operations can trap
AC_DEFUN([AC_CFLAGS_WANT_TRAPPING_MATH],
[AC_CFLAGS_DO_WANT([$1],[$2],[-ftrapping-math])])

AC_DEFUN([AC_CXXFLAGS_WANT_TRAPPING_MATH],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-ftrapping-math])])

dnl set errno after built-in math functions
AC_DEFUN([AC_CFLAGS_WANT_MATH_ERRNO],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fmath-errno])])

AC_DEFUN([AC_CXXFLAGS_WANT_MATH_ERRNO],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fmath-errno])])

dnl enables guessing of branch probabilities
AC_DEFUN([AC_CFLAGS_WANT_GUESS_BRANCH_PROBABILITY],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fguess-branch-probability])])

AC_DEFUN([AC_CXXFLAGS_WANT_GUESS_BRANCH_PROBABILITY],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fguess-branch-probability])])

dnl external symbols have a leading underscore
AC_DEFUN([AC_CFLAGS_WANT_LEADING_UNDERSCORE],
[AC_CFLAGS_DO_WANT([$1],[$2],
	[-fleading-underscore],[-fno-leading-underscore])])

AC_DEFUN([AC_CFLAGS_WANT_NO_LEADING_UNDERSCORE],
[AC_CFLAGS_WANT_NO([$1],[$2],
	[-fleading-underscore],[-fno-leading-underscore])])

AC_DEFUN([AC_CXXFLAGS_WANT_LEADING_UNDERSCORE],
[AC_CXXFLAGS_DO_WANT([$1],[$2],
	[-fleading-underscore],[-fno-leading-underscore])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_LEADING_UNDERSCORE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
	[-fleading-underscore],[-fno-leading-underscore])])

dnl insert stack checking code into the program
AC_DEFUN([AC_CFLAGS_WANT_STACK_CHECK],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fstack-check])])

AC_DEFUN([AC_CXXFLAGS_WANT_STACK_CHECK],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fstack-check])])

dnl do not put uninitialized globals into the common section
AC_DEFUN([AC_CFLAGS_WANT_NO_COMMON],
[AC_CFLAGS_WANT_NO([$1],[$2],[-fcommon],[-fno-common])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_COMMON],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fcommon],[-fno-common])])

dnl enable exception handling
AC_DEFUN([AC_CXXFLAGS_WANT_EXCEPTIONS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fexceptions],[-fno-exceptions])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_EXCEPTIONS],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fexceptions],[-fno-exceptions])])

dnl do not perform the global common subexpression elimination
AC_DEFUN([AC_CFLAGS_WANT_NO_GCSE],
[AC_CFLAGS_WANT_NO([$1],[$2],[-fgsce],[-fno-gsce])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_GCSE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fgsce],[-fno-gsce])])

dnl do not respect the "inline" keyword
AC_DEFUN([AC_CFLAGS_WANT_NO_INLINE],
[AC_CFLAGS_WANT_NO([$1],[$2],[-finline],[-fno-inline])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_INLINE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-finline],[-fno-inline])])

dnl integrate simple functions into their callers
AC_DEFUN([AC_CFLAGS_WANT_INLINE_FUNCTIONS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-finline-functions],[-fno-inline-functions])])

AC_DEFUN([AC_CFLAGS_WANT_NO_INLINE_FUNCTIONS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-finline-functions],[-fno-inline-functions])])

AC_DEFUN([AC_CXXFLAGS_WANT_INLINE_FUNCTIONS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-finline-functions],[-fno-inline-functions])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_INLINE_FUNCTIONS],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-finline-functions],[-fno-inline-functions])])

dnl integrate simple functions into their callers
AC_DEFUN([AC_CFLAGS_WANT_KEEP_INLINE_FUNCTIONS],
[AC_CFLAGS_DO_WANT([$1],[$2],
  [-fkeep-inline-functions],[-fno-keep-inline-functions])])

AC_DEFUN([AC_CFLAGS_WANT_NO_KEEP_INLINE_FUNCTIONS],
[AC_CFLAGS_WANT_NO([$1],[$2],
  [-fkeep-inline-functions],[-fno-keep-inline-functions])])

AC_DEFUN([AC_CXXFLAGS_WANT_KEEP_INLINE_FUNCTIONS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],
  [-fkeep-inline-functions],[-fno-keep-inline-functions])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_KEEP_INLINE_FUNCTIONS],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
  [-fkeep-inline-functions],[-fno-keep-inline-functions])])

dnl ac_cflags_want_no_writable_strings -> ac_prog_cc_no_writable_strings

dnl when possible do not generate stack frames
AC_DEFUN([AC_CFLAGS_WANT_NO_FRAME_POINTER],
[AC_CFLAGS_WANT_NO([$1],[$2],
  [-fno-omit-frame-pointer],[-fomit-frame-pointer])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_FRAME_POINTER],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
  [-fno-omit-frame-pointer],[-fomit-frame-pointer])])

dnl defer popping functions args from stack until later
AC_DEFUN([AC_CFLAGS_WANT_DEFER_POP],
[AC_CFLAGS_DO_WANT([$1],[$2], [-fdefer-pop],[-fno-defer-pop])])

AC_DEFUN([AC_CXXFLAGS_WANT_DEFER_POP],
[AC_CXXFLAGS_DO_WANT([$1],[$2], [-fdefer-pop],[-fno-defer-pop])])

dnl consider all mem refs to static data to be volatile
AC_DEFUN([AC_CFLAGS_WANT_VOLATILE_STATIC],
[AC_CFLAGS_DO_WANT([$1],[$2], [-fvolatile-static],[-fno-volatile-static])])

AC_DEFUN([AC_CFLAGS_WANT_NO_VOLATILE_STATIC],
[AC_CFLAGS_WANT_NO([$1],[$2], [-fvolatile-static],[-fno-volatile-static])])

AC_DEFUN([AC_CXXFLAGS_WANT_VOLATILE_STATIC],
[AC_CXXFLAGS_DO_WANT([$1],[$2], [-fvolatile-static],[-fno-volatile-static])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_VOLATILE_STATIC],
[AC_CXXFLAGS_WANT_NO([$1],[$2], [-fvolatile-static],[-fno-volatile-static])])

dnl consider all mem refs to global data to be volatile
AC_DEFUN([AC_CFLAGS_WANT_VOLATILE_GLOBAL],
[AC_CFLAGS_DO_WANT([$1],[$2], [-fvolatile-global],[-fno-volatile-global])])

AC_DEFUN([AC_CFLAGS_WANT_NO_VOLATILE_GLOBAL],
[AC_CFLAGS_WANT_NO([$1],[$2], [-fvolatile-global],[-fno-volatile-global])])

AC_DEFUN([AC_CXXFLAGS_WANT_VOLATILE_GLOBAL],
[AC_CXXFLAGS_DO_WANT([$1],[$2], [-fvolatile-global],[-fno-volatile-global])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_VOLATILE_GLOBAL],
[AC_CXXFLAGS_WANT_NO([$1],[$2], [-fvolatile-global],[-fno-volatile-global])])

dnl consider all mem refs through pointers as volatile
AC_DEFUN([AC_CFLAGS_WANT_VOLATILE],
[AC_CFLAGS_DO_WANT([$1],[$2], [-fvolatile],[-fno-volatile])])

AC_DEFUN([AC_CFLAGS_WANT_NO_VOLATILE],
[AC_CFLAGS_WANT_NO([$1],[$2], [-fvolatile],[-fno-volatile])])

AC_DEFUN([AC_CXXFLAGS_WANT_VOLATILE],
[AC_CXXFLAGS_DO_WANT([$1],[$2], [-fvolatile],[-fno-volatile])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_VOLATILE],
[AC_CXXFLAGS_WANT_NO([$1],[$2], [-fvolatile],[-fno-volatile])])

dnl warn about functions which might be candidates for attribute noreturn
AC_DEFUN([AC_CFLAGS_WARN_AT_MISSING_NORETURN],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wmissing-noreturn],[-Wno-missing-noreturn])])

AC_DEFUN([AC_CFLAGS_NO_WARN_MISSING_NORETURN],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wmissing-noreturn],[-Wno-missing-noreturn])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_MISSING_NORETURN],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wmissing-noreturn],[-Wno-missing-noreturn])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_MISSING_NORETURN],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wmissing-noreturn],[-Wno-missing-noreturn])])

dnl warn when padding is required to align struct members
AC_DEFUN([AC_CFLAGS_WARN_AT_PADDED],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wpadded],[-Wno-padded])])

AC_DEFUN([AC_CFLAGS_NO_WARN_PADDED],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wpadded],[-Wno-padded])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_PADDED],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wpadded],[-Wno-padded])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_PADDED],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wpadded],[-Wno-padded])])

dnl warn when the packed attribute has no effect on struct layout
AC_DEFUN([AC_CFLAGS_WARN_AT_PACKED],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wpacked],[-Wno-packed])])

AC_DEFUN([AC_CFLAGS_NO_WARN_PACKED],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wpacked],[-Wno-packed])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_PACKED],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wpacked],[-Wno-packed])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_PACKED],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wpacked],[-Wno-packed])])

dnl warn when an inlined function cannot be inlined
AC_DEFUN([AC_CFLAGS_WARN_AT_INLINE],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Winline],[-Wno-inline])])

AC_DEFUN([AC_CFLAGS_NO_WARN_INLINE],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Winline],[-Wno-inline])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_INLINE],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Winline],[-Wno-inline])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_INLINE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Winline],[-Wno-inline])])

dnl warn about uninitialized automatic variables
AC_DEFUN([AC_CFLAGS_WARN_AT_UNINITIALIZED],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wuninitialized],[-Wno-uninitialized])])

AC_DEFUN([AC_CFLAGS_NO_WARN_UNINITIALIZED],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wuninitialized],[-Wno-uninitialized])])

dnl warn about code that will never be executed
AC_DEFUN([AC_CFLAGS_WARN_AT_UNREACHABLE_CODE],
[AC_CFLAGS_DO_WANT([$1],[$2],[-Wunreachable-code],[-Wno-unreachable-code])])

AC_DEFUN([AC_CFLAGS_NO_WARN_UNREACHABLE_CODE],
[AC_CFLAGS_WANT_NO([$1],[$2],[-Wunreachable-code],[-Wno-unreachable-code])])

AC_DEFUN([AC_CXXFLAGS_WARN_AT_UNREACHABLE_CODE],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wunreachable-code],[-Wno-unreachable-code])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_UNREACHABLE_CODE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wunreachable-code],[-Wno-unreachable-code])])

dnl ac_cflags_want_unsigned_char -> ..................

dnl do not recognize any built in functions
AC_DEFUN([AC_CFLAGS_WANT_NO_BUILTINS],
[AC_CFLAGS_WANT_NO([$1],[$2],[-fno-builtin],[-fbuiltin])])

dnl assume that libc (and main) do not exist
AC_DEFUN([AC_CFLAGS_WANT_FREESTANDING],
[AC_CFLAGS_DO_WANT([$1],[$2],[-ffreestanding],[-fno-freestanding])])

dnl allow the use of dollar-sign inside identifiers
AC_DEFUN([AC_CFLAGS_WANT_DOLLARS_IN_IDENTIFIERS],
[AC_CFLAGS_DO_WANT([$1],[$2],[-fdollars-in-identifiers])])

dnl ................................ C++ ..............................

dnl check the return value of new
AC_DEFUN([AC_CXXFLAGS_WANT_CHECK_NEW],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fcheck-new],[-fno-check-new])])

AC_DEFUN([AC_CXXFLAGS_WANT_NO_CHECK_NEW],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fcheck-new],[-fno-check-new])])

dnl do not inline member functions by default
AC_DEFUN([AC_CXXFLAGS_WANT_NO_DEFAULT_INLINE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fdefault-inline],[-fno-default-inline])])

AC_DEFUN([AC_CXXFLAGS_WANT_DEFAULT_INLINE],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fdefault-inline],[-fno-default-inline])])

dnl do not generate run time type descriptor information
AC_DEFUN([AC_CXXFLAGS_WANT_NO_RTTI],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-frtti],[-fno-rtti])])

AC_DEFUN([AC_CXXFLAGS_WANT_RTTI],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-frtti],[-fno-rtti])])

dnl do not generate code to check exception specifications
AC_DEFUN([AC_CXXFLAGS_WANT_NO_ENFORCE_EH_SPECS],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fenforce-eh-specs],[-fno-enforce-eh-specs])])

AC_DEFUN([AC_CXXFLAGS_WANT_ENFORCE_EH_SPECS],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fenforce-eh-specs],[-fno-enforce-eh-specs])])

dnl export functions even if they can be inlined
AC_DEFUN([AC_CXXFLAGS_WANT_NO_IMPLEMENT_INLINES],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-fimplement-inlines],-fno-implement-inlines)])

AC_DEFUN([AC_CXXFLAGS_WANT_IMPLEMENT_INLINES],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-fimplement-inlines],-fno-implement-inlines)])

dnl only emit expclit template instantiations
AC_DEFUN([AC_CXXFLAGS_WANT_NO_IMPLICIT_TEMPLATES],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
	[-fimplicit-templates],[-fno-implicit-templates])])

AC_DEFUN([AC_CXXFLAGS_WANT_IMPLICIT_TEMPLATES],
[AC_CXXFLAGS_DO_WANT([$1],[$2],
	[-fimplicit-templates],[-fno-implicit-templates])])

dnl only emit expclit template instantiations of inline templates
AC_DEFUN([AC_CXXFLAGS_WANT_NO_IMPLICIT-INLINE_TEMPLATES],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
	[-fimplicit-inline-templates],[-fno-implicit-inline-templates])])

AC_DEFUN([AC_CXXFLAGS_WANT_IMPLICIT-INLINE_TEMPLATES],
[AC_CXXFLAGS_DO_WANT([$1],[$2],
	[-fimplicit-inline-templates],[-fno-implicit-inline-templates])])

dnl warn about inconsistent return types
AC_DEFUN([AC_CXXFLAGS_WARN_AT_RETURN_TYPE],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wreturn-type],[-Wno-return-type])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_RETURN_TYPE],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wreturn-type],[-Wno-return-type])])

dnl warn about overloaded virtual function names
AC_DEFUN([AC_CXXFLAGS_WARN_AT_OVERLOADED_VIRTUAL],
[AC_CXXFLAGS_DO_WANT([$1],[$2],
	[-Woverloaded-virtual],[-Wno-overloaded-virtual])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_OVERLOADED_VIRTUAL],
[AC_CXXFLAGS_WANT_NO([$1],[$2],
	[-Woverloaded-virtual],[-Wno-overloaded-virtual])])

dnl warn about non virtual destructors
AC_DEFUN([AC_CXXFLAGS_WARN_AT_NON_VIRTUAL_DTOR],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wnon-virtual-dtor],[-Wno-non-virtual-dtor])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_NON_VIRTUAL_DTOR],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wnon-virtual-dtor],[-Wno-non-virtual-dtor])])

dnl warn when the compiler reorders code (e.g. constructor list)
AC_DEFUN([AC_CXXFLAGS_WARN_AT_REORDER],
[AC_CXXFLAGS_DO_WANT([$1],[$2],[-Wreorder],[-Wno-reorder])])

AC_DEFUN([AC_CXXFLAGS_NO_WARN_REORDER],
[AC_CXXFLAGS_WANT_NO([$1],[$2],[-Wreorder],[-Wno-reorder])])
