dnl @synopsis AX_CFLAGS_STRICT_PROTOTYPES [(shellvar)]
dnl
dnl Try to find a compiler option that requires strict prototypes.
dnl
dnl The sanity check is done by looking at sys/signal.h which has a set
dnl of macro-definitions SIG_DFL and SIG_IGN that are cast to the local
dnl signal-handler type. If that signal-handler type is not fully
dnl qualified then the system headers are not seen as strictly prototype clean.
dnl
dnl For the GNU CC compiler it will be -fstrict-prototypes -Wstrict-prototypes
dnl The result is added to the shellvar being CFLAGS by default.
dnl
dnl @version $Id: ax_cflags_strict_prototypes.m4,v 1.1 2003/01/06 00:51 ac-archive-0.5.39 $
dnl @author Guido Draheim <guidod@gmx.de>
dnl
AC_DEFUN([AX_CFLAGS_STRICT_PROTOTYPES], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CFLAGS) for strict prototypes)
AC_CACHE_VAL(ac_cv_cflags_strict_prototypes,
[ac_cv_cflags_strict_prototypes="no, unknown"
 AC_LANG_SAVE
 AC_LANG_C
 ac_save_CFLAGS="$CFLAGS"
for ac_arg dnl
in "-Wall     % -fstrict-prototypes -Wstrict-prototypes" dnl   GCC
   "-Wall     % -Wstrict-prototypes" dnl try to warn atleast
   # 
do CFLAGS="$ac_save_CFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cflags_strict_prototypes=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
case "$ac_cv_cflags_strict_prototypes" in
   no,*) ;;
   *)
AC_TRY_COMPILE(
[#include <sys/signal.h>],[
    if (signal (SIGINT, SIG_IGN) == SIG_DFL) return 1;],[],
[ac_cv_cflags_strict_prototypes="no, suppressed, sys/signal.h"
 cp conftest.c testtest.c
]) ;;
esac
 CFLAGS="$ac_save_CFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cflags_strict_prototypes" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cflags_strict_prototypes) ;;
   *) m4_ifval($1,$1,CFLAGS)="$m4_ifval($1,$1,CFLAGS) dnl
$ac_cv_cflags_strict_prototypes"
      AC_MSG_RESULT($ac_cv_cflags_strict_prototypes) ;;
esac])

dnl the only difference - the LANG selection... and the default FLAGS

AC_DEFUN([AX_CXXFLAGS_STRICT_PROTOTYPES], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CXXFLAGS) for strict prototypes)
AC_CACHE_VAL(ac_cv_cxxflags_strict_prototypes,
[ac_cv_cxxflags_strict_prototypes="no, unknown"
 AC_LANG_SAVE
 AC_LANG_CXX
 ac_save_CXXFLAGS="$CXXFLAGS"
for ac_arg dnl
in "-Wall     % -fstrict-prototypes -Wstrict-prototypes" dnl   GCC
   "-Wall     % -Wstrict-prototypes" dnl try to warn atleast
   # 
do CXXFLAGS="$ac_save_CXXFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cxxflags_strict_prototypes=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
case "$ac_cv_cxxflags_strict_prototypes" in
   no,*) ;;
   *)
AC_TRY_COMPILE(
[#include <sys/signal.h>],[
    if (signal (SIGINT, SIG_IGN) == SIG_DFL) return 1;],[],
[ac_cv_cxxflags_strict_prototypes="no, suppressed, sys/signal.h"
 cp conftest.c testtest.c
]) ;;
esac
 CXXFLAGS="$ac_save_CXXFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cxxflags_strict_prototypes" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cxxflags_strict_prototypes) ;;
   *) m4_ifval($1,$1,CXXFLAGS)="$m4_ifval($1,$1,CXXFLAGS) dnl
$ac_cv_cxxflags_strict_prototypes"
      AC_MSG_RESULT($ac_cv_cxxflags_strict_prototypes) ;;
esac])
