dnl @synopsis AX_CFLAGS_WARN_ALL_ANSI [(shellvar)]
dnl
dnl Try to find a compiler option that enables most reasonable warnings.
dnl This macro is directly derived from VL_PROG_CC_WARNINGS which is
dnl split up into two AX_CFLAGS_WARN_ALL and AX_CFLAGS_WARN_ALL_ANSI
dnl
dnl For the GNU CC compiler it will be -Wall (and -ansi -pedantic)
dnl The result is added to the shellvar being CFLAGS by default.
dnl
dnl Currently this macro knows about GCC, Solaris C compiler,
dnl Digital Unix C compiler, C for AIX Compiler, HP-UX C compiler,
dnl IRIX C compiler, NEC SX-5 (Super-UX 10) C compiler, and Cray J90
dnl (Unicos 10.0.0.8) C compiler.
dnl
dnl @version $Id: ax_cflags_warn_all_ansi.m4,v 1.1 2003/01/06 00:51 ac-archive-0.5.39 $
dnl @author Guido Draheim <guidod@gmx.de>
dnl
AC_DEFUN([AX_CFLAGS_WARN_ALL_ANSI], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CFLAGS) for maximum ansi warnings)
AC_CACHE_VAL(ac_cv_cflags_warn_all_ansi,
[ac_cv_cflags_warn_all_ansi="no, unknown"
 AC_LANG_SAVE
 AC_LANG_C
 ac_save_CFLAGS="$CFLAGS"
# IRIX C compiler:
#      -use_readonly_const is the default for IRIX C,
#       puts them into .rodata, but they are copied later.
#       need to be "-G0 -rdatashared" for strictmode but
#       I am not sure what effect that has really.         - guidod
for ac_arg dnl
in "-pedantic  % -Wall -ansi -pedantic"       dnl   GCC
   "-xstrconst % -v -Xc"                      dnl Solaris C 
   "-std1      % -verbose -w0 -warnprotos -std1" dnl Digital Unix 
   " % -qlanglvl=ansi -qsrcmsg -qinfo=all:noppt:noppc:noobs:nocnd" dnl AIX
   " % -ansi -ansiE -fullwarn"                dnl IRIX
   "+ESlit     % +w1 -Aa"                     dnl HP-UX C 
   "-Xc        % -pvctl[,]fullmsg -Xc"        dnl NEC SX-5 (Super-UX 10)
   "-h conform % -h msglevel 2 -h conform"    dnl Cray C (Unicos)
   # 
do CFLAGS="$ac_save_CFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cflags_warn_all_ansi=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
 CFLAGS="$ac_save_CFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cflags_warn_all_ansi" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cflags_warn_all_ansi) ;;
   *) m4_ifval($1,$1,CFLAGS)="$m4_ifval($1,$1,CFLAGS) dnl
$ac_cv_cflags_warn_all_ansi"
      AC_MSG_RESULT($ac_cv_cflags_warn_all_ansi) ;;
esac])

dnl the only difference - the LANG selection... and the default FLAGS

AC_DEFUN([AX_CXXFLAGS_WARN_ALL_ANSI], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CXXFLAGS) for maximum ansi warnings)
AC_CACHE_VAL(ac_cv_cxxflags_warn_all_ansi,
[ac_cv_cxxflags_warn_all_ansi="no, unknown"
 AC_LANG_SAVE
 AC_LANG_CXX
 ac_save_CXXFLAGS="$CXXFLAGS"
# IRIX C compiler:
#      -use_readonly_const is the default for IRIX C,
#       puts them into .rodata, but they are copied later.
#       need to be "-G0 -rdatashared" for strictmode but
#       I am not sure what effect that has really.         - guidod
for ac_arg dnl
in "-pedantic  % -Wall -ansi -pedantic"       dnl   GCC
   "-xstrconst % -v -Xc"                      dnl Solaris C 
   "-std1      % -verbose -w0 -warnprotos -std1" dnl Digital Unix 
   " % -qlanglvl=ansi -qsrcmsg -qinfo=all:noppt:noppc:noobs:nocnd" dnl AIX
   " % -ansi -ansiE -fullwarn"                dnl IRIX
   "+ESlit     % +w1 -Aa"                     dnl HP-UX C 
   "-Xc        % -pvctl[,]fullmsg -Xc"        dnl NEC SX-5 (Super-UX 10)
   "-h conform % -h msglevel 2 -h conform"    dnl Cray C (Unicos)
   # 
do CXXFLAGS="$ac_save_CXXFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cxxflags_warn_all_ansi=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
 CXXFLAGS="$ac_save_CXXFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cxxflags_warn_all_ansi" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cxxflags_warn_all_ansi) ;;
   *) m4_ifval($1,$1,CXXFLAGS)="$m4_ifval($1,$1,CXXFLAGS) dnl
$ac_cv_cxxflags_warn_all_ansi"
      AC_MSG_RESULT($ac_cv_cxxflags_warn_all_ansi) ;;
esac])
