dnl @synopsis AC_CHECK_USER
dnl
dnl Check if the specified UNIX user exists,
dnl if yes set your environment variable to that username
dnl else unset your environment variable
dnl
dnl Example:
dnl
dnl     AC_CHECK_USER(USER, [gleensalmon])
dnl     if test x$USER = xgleensalmon; then
dnl         bla..bla..bla..
dnl     else
dnl         bla..bla..bla..
dnl     fi
dnl
dnl Besides checking existence, this macro also set these environment variables upon completion:
dnl
dnl     USER_HOME = home directory of user, written in /etc/passwd
dnl
dnl @version $Id: ac_check_user.m4,v 1.1 2002/09/12 21:45 ac-archive-0.5.39 $
dnl @author Gleen Salmon <gleensalmon@yahoo.com>
dnl
AC_DEFUN([AC_CHECK_USER],[
AC_MSG_CHECKING([for user $2])
if grep ^$2: /etc/passwd > /dev/null; then
        $1=$2
        USER_HOME=`grep ^$2: /etc/passwd | sed "s/^\([[^:]]*:\)\{5\}\([[^:]]*\):[[^:]]*$/\2/"`
        AC_MSG_RESULT([yes])
else
        unset $1
        unset USER_HOME
        AC_MSG_RESULT([no])
fi;dnl
])
