<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: manages the output of Query results
 */

include_once("acid_constants.inc");

class QueryResultsOutput
{
  var $qroHeader;
  var $url;

  function QueryResultsOutput($uri)
  {
    $this->url = $uri;
  }

  function AddTitle($title, $asc_sort = " ", $asc_sort_sql1 = "", $asc_sort_sql2 = "",
                            $desc_sort = " ", $desc_sort_sql1 = "", $desc_sort_sql2 = "")
  {
    $this->qroHeader[$title] = array( $asc_sort  => array( $asc_sort_sql1, $asc_sort_sql2 ),
                                     $desc_sort => array( $desc_sort_sql1, $desc_sort_sql2 ) ); 
 }

  function GetSortSQL($sort, $sort_order)
  {
    reset($this->qroHeader);
    while( $title = each($this->qroHeader) )
    {
      if ( in_array($sort, array_keys($title["value"])) )
      {
         $tmp_sort = $title["value"][$sort];
         //$tmp_sort_caller = $title["value"][$sort_order];

         //if ( $sort_order != "" )
         //  $tmp_sort[1] = ereg_replace("ORDER BY", $tmp_sort_caller[1].",", 
         //                              $tmp_sort[1]);

         return $tmp_sort;
      }      
    }

    /* $sort is not a valid sort type of any header */
    return NULL;
  }
 
  function PrintHeader()
  {
     /* Client-side Javascript to select all the check-boxes on the screen
      *   - Bill Marque (wlmarque@hewitt.com) */
     echo '
          <SCRIPT Language=Javascript>
            function SelectAll()
            {
               for(var i=0;i<document.PacketForm.elements.length;i++)
               {
                  if(document.PacketForm.elements[i].type == "checkbox")
                  {
                    document.PacketForm.elements[i].checked = true;
                  }
               }
            }
      
            function UnselectAll()
            {
                for(var i=0;i<document.PacketForm.elements.length;i++)
                {
                    if(document.PacketForm.elements[i].type == "checkbox")
                    {
                      document.PacketForm.elements[i].checked = false;
                    }
                }
            }
           </SCRIPT>';

     echo '<TABLE CELLSPACING=0 CELLPADDING=2 BORDER=0 WIDTH="100%" BGCOLOR="#000000">'."\n".
          "<TR><TD>\n".
          '<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH="100%" BGCOLOR="#FFFFFF">'."\n".
          "\n\n<!-- Query Results Title Bar -->\n   <TR>\n";

     reset($this->qroHeader);
     while( $title = each($this->qroHeader) )
     {
       $print_title = "";

       $sort_keys = array_keys($title["value"]);
       if ( count($sort_keys) == 2 )
       {
          $print_title = "<A HREF=\"".$this->url."&sort_order=".$sort_keys[0]."\">&lt;</A>".
                         "&nbsp;".$title["key"]."&nbsp;".
                         "<A HREF=\"".$this->url."&sort_order=".$sort_keys[1]."\">&gt;</A>";
       }
       else
       {
          $print_title = $title["key"];
       }
    
       echo '    <TD CLASS="plfieldhdr">&nbsp;'.$print_title.'&nbsp;</TD>'."\n";
     }

    echo "   </TR>\n";
  }

  function PrintFooter()
  {
    echo "  </TABLE>\n
           </TD></TR>\n
          </TABLE>\n";
  }

  function DumpQROHeader()
  {
    echo "<B>Query Results Output Header</B>
          <PRE>";
    print_r($this->qroHeader);
    echo "</PRE>";
  }
}

function qroReturnSelectALLCheck()
{
  return '<INPUT type=checkbox value="Select All" onClick="if (this.checked) SelectAll(); if (!this.checked) UnselectAll();">';
}

function qroPrintEntryHeader($seq=1)
{
  echo '<TR BGCOLOR="#'.((($seq % 2) == 0) ? "DDDDDD" : "FFFFFF").'">';
}

function qroPrintEntry($value)
{
  echo "<TD ALIGN=CENTER>\n".
       "  <FONT>&nbsp;&nbsp;\n".
       "        $value\n".
       "        &nbsp;&nbsp;</FONT>\n".
       "</TD>\n\n";
}

function qroPrintEntryFooter()
{
  echo '</TR>';
}

?>