<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Maintenance and configuration page for
 *          managing Alert Groups (AG)   
 *
 * Input GET/POST variables
 *   - ag_action:
 *   - ag_id: 
 *   - submit:
 */

  include("acid_constants.inc");
  include("acid_conf.php");
  include("acid_include.inc");
  include_once("acid_action.inc");
  include_once("acid_db_common.php");
  include_once("acid_common.php");
  include_once("acid_qry_common.php");
  include_once("acid_ag_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_ag_main.php");
  $cs->ReadState();
  

  $qs = new QueryState();
  $submit = ImportHTTPVar("submit");
  $ag_action = ImportHTTPVar("ag_action");
  $ag_id = ImportHTTPVar("ag_id");
  
  //$qs->MoveView($submit);             /* increment the view if neccessary */

  $page_title = "Alert Group (AG) Maintenance";
  PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  /* a browsing button was clicked */
  if ( is_numeric($submit) )
  {
    if ( $debug_mode > 0 ) ErrorMessage("Browsing Clicked ($submit)");
    $qs->MoveView($submit);
    $ag_action = "view";
  }
?>

<CENTER>
 <A HREF="acid_ag_main.php?ag_action=list">list all</A> | 
 <A HREF="acid_ag_main.php?ag_action=create">create</A> |
 <A HREF="acid_ag_main.php?ag_action=view">view</A> |
 <A HREF="acid_ag_main.php?ag_action=edit">edit</A> |
 <A HREF="acid_ag_main.php?ag_action=delete">delete</A> |
 <A HREF="acid_ag_main.php?ag_action=clear">clear</A>
</CENTER>
<HR>

<FORM METHOD="POST" NAME="PacketForm" ACTION="acid_ag_main.php">

<?php
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>ag_action</TD><TD>submit</TD><TD>ag_id</TD></TR>
             <TR><TD>'.$ag_action.'</TD><TD>'.$submit.'</TD><TD>'.$ag_id.'</TD></TR>
           </TABLE>';

  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("clear_alert");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");
  $qs->AddValidActionOp("Entire Query");

  $qs->SetActionSQL("SELECT ag_sid, ag_cid FROM acid_ag_alert WHERE ag_id=".$ag_id); 
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_QRY_AG, $db);
  $et->Mark("Alert Action");

  if ( $ag_action == "create" )                                       echo '<H3>Create group</H3>';
  else if ($ag_action == "view" )                                     echo '<H3>View group</H3>';
  else if ($ag_action == "edit" || $ag_action == "save" )             echo '<H3>Edit group</H3>';
  else if ($ag_action == "delete" || $ag_action == "delete_confirm" ) echo '<H3>Delete group</H3>';
  else if ($ag_action == "clear" || $ag_action == "clear_confirm" )   echo '<H3>Clear group</H3>';
  else if ($ag_action == "list" )                                     echo '<H3>List groups</H3>';
  else
    $ag_action = "list";
  

  if ( $submit != "" )
  {
     if ( $ag_action == "create" )
     {
        $sql = "INSERT INTO acid_ag (ag_name, ag_desc) VALUES ('".$ag_name."','".$ag_desc."');";
        $db->acidExecute($sql, -1, -1, false);

        if ( $db->acidErrorMessage() != "" )
           FatalError("Error Inserting new AG");

        $ag_id = $db->acidInsertID();
        /* The following code is a kludge and can cause errors.  Since it is not possible
         * to determine the last insert ID of the AG, we requery the DB to ascertain the ID
         * by matching on the ag_name and ag_desc.  -- rdd (1/23/2001)
         *
         * Modified code to only run the kludge if the dbtype is postgres.  Created a function
         * to use the actual insertid function if available and return -1 if no -- srh (02/01/2001)
         *
         * Transaction support is neccessary to get this absolutely correct, because using
         * an insert_id might break in a multi-user environment.  -- rdd (02/07/2001)
         */
         if ( $ag_id == -1 )
         {
            $tmp_sql = "SELECT ag_id FROM acid_ag WHERE ag_name='".$ag_name."' AND ".
                                        "ag_desc='".$ag_desc."'";
            if ($db->DB_type == "mssql")
              $tmp_sql = "SELECT ag_id FROM acid_ag WHERE ag_name='".$ag_name."' AND ".
                                        "ag_desc LIKE '".MssqlKludgeValue($ag_desc)."'";
            $tmp_result = $db->acidExecute();
            $myrow = $tmp_result->acidFetchRow();
            $ag_id = $myrow[0];
            $tmp_result->acidFreeRows();
         }
         $ag_action = "view";
     }
     else if ( $ag_action == "save" )
     {
        $sql = "UPDATE acid_ag SET ag_name='".$ag_name."', ag_desc='".$ag_desc."' ".
               "WHERE ag_id=".$ag_id;

        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error updating the AG");

        $ag_action = "view";
     }
     else if ( $ag_action == "delete_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting packet list for the AG: ".$sql);

        /* Delete the AG */
        $sql = "DELETE FROM acid_ag WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting the AG".$sql);
     }
     else if ( $ag_action == "clear_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting packet list for the AG: ".$sql);
        
        $ag_action = "view";
     }

     if ( $ag_action == "delete_confirm" )
     {
        ErrorMessage("<B>DELETED successfully</B>");
        $ag_action = "view";
        $ag_name = $ag_desc = "<I>information deleted</I>";
     }
     else
     {
     /* Re-Query the information to print the AG info out */
     if ( $ag_id > 0)
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_id=".$ag_id;
     else
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_name='".$ag_name."'";

     $result = $db->acidExecute($sql, -1, -1, false);
     if ( $db->acidErrorMessage() != "" )
     {
        ErrorMessage("The entered search criteria is invalid.  Try again!");
        $submit = "";
     }
     else if ( $result->acidRecordCount() < 1 )
     {
        ErrorMessage("No AG found with that criteria.".$sql);
        $submit = "";
     }
     else
     {
        $myrow = $result->acidFetchRow();
        $ag_id = $myrow[0];
        $ag_name = $myrow[1];
        $ag_desc = $myrow[2]; 
     }
     }
  }

  if ( $ag_action == "list" )
  {
     $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag";

     $result = $db->acidExecute($sql);
     $num = $result->acidRecordCount();
     if ( $num < 1 )
     {
        echo "<CENTER><B>There are no Alert Groups</B></CENTER>";
     }
     else
     {
       echo '<TABLE BORDER=1 CELLSPACING=0 PADDING=0 WIDTH="100%">
`              <TR>
               <TD CLASS="plfieldhdr">ID</TD>
               <TD CLASS="plfieldhdr">Name</TD>
               <TD CLASS="plfieldhdr"># Alerts</TD>
               <TD CLASS="plfieldhdr">Description</TD>
               <TD CLASS="plfieldhdr">Actions</TD>
              </TR>';
        for ( $i = 0; $i < $num; $i++)
        {
           $myrow = $result->acidFetchRow();

           /* count the number of alerts in the AG */
           $result2 = $db->acidExecute("SELECT count(ag_cid) FROM acid_ag_alert WHERE ag_id=".$myrow[0]);
           $myrow2 = $result2->acidFetchRow();
           $num_alerts = $myrow2[0];
           $result2->acidFreeRows();

           echo '<TR><TD CLASS="plfield">
                     <A HREF="acid_ag_main.php?ag_action=view&ag_id='.$myrow[0].'&submit=x">'.$myrow[0].'</A></TD>
                     <TD CLASS="plfield">'.$myrow[1].'</TD>
                     <TD CLASS="plfield">'.$num_alerts.'</TD>
                     <TD CLASS="plfield">'.$myrow[2].'</TD>
                     <TD CLASS="plfield"> 
                       <A HREF="acid_ag_main.php?ag_action=edit&ag_id='.$myrow[0].'&submit=x">edit</A> |
                       <A HREF="acid_ag_main.php?ag_action=delete&ag_id='.$myrow[0].'&submit=x">delete</A> |
                       <A HREF="acid_ag_main.php?ag_action=clear&ag_id='.$myrow[0].'&submit=x">clear</A>
                     </TD>
                 </TR>';
        }
        echo '</TABLE>';
        $result->acidFreeRows();
     }
  }

  if ( $ag_action != "list" )
  {
     echo '<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
           <TR>
            <TD WIDTH="10%"><B>ID #</B></TD>
            <TD>';

            if ( $ag_action == "create" && $submit == "")
               echo '&nbsp;<I> not assigned yet </I>&nbsp';
            else if ( $submit == "" )
               echo '<INPUT TYPE="text" NAME="ag_id" VALUE="'.$ag_id.'">';
            else if ( ($ag_action == "view" || $ag_action == "edit" || 
                       $ag_action == "delete" || $ag_action == "clear") &&
                      $submit != "" )
            {
               echo '<INPUT TYPE="hidden" NAME="ag_id" VALUE="'.$ag_id.'">';
               echo $ag_id;
            }

     echo ' </TD>
           <TR>
            <TD VALIGN=TOP><B>Name</B></TD>
            <TD>';

            if ( $ag_action == "create" && $submit == "")
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40 VALUE="'.$ag_name.'">';
            else if ( $submit == "" )
            {
               echo '<SELECT NAME="ag_name">
                       <OPTION VALUE="">{ AG Name }';
               $sql = "SELECT ag_name FROM acid_ag;";
               $result = $db->acidExecute($sql);
               if ( $result )
               {
                  while ( $myrow = $result->acidFetchRow() )
                      echo '<OPTION VALUE="'.$myrow[0].'">'.$myrow[0];

                  $result->acidFreeRows();
               }

               echo '</SELECT>';
            }
            else if ( $ag_action == "edit" && $submit != "" )
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40" VALUE="'.$ag_name.'">';
            else if ( ($ag_action == "view" || $ag_action == "delete" || 
                       $ag_action = "clear") && 
                      $submit != "" )
               echo $ag_name;

     echo ' </TD>';
     
     if ( ($ag_action == "create" && $submit == "") ||
          (($ag_action == "view" || $ag_action == "edit" || 
            $ag_action == "delete" || $ag_action == "clear") && 
          $submit != "" ) )
     {
       echo '
          <TR>
           <TD VALIGN=TOP><B>Description</B></TD>
           <TD>';

            if ( $ag_action == "create" && $submit == "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( $ag_action == "edit" && $submit != "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( ($ag_action == "view" || $ag_action == "delete" || 
                       $ag_action == "clear") && 
                      $submit != "" )
               echo $ag_desc;

       echo '
           </TD>
          </TR>';
     }

     echo '</TABLE>';
 
   /* Print the Appropriate button */
   if ( $submit == "" || $ag_action == "edit" || $ag_action == "delete" || $ag_action == "clear" )
   {
     echo '<CENTER> <FONT>';

     if ( $ag_action == "create" )      $button_text = "Create Alert Group";
     else if ( $ag_action == "view" )   $button_text = "View Alert Group";
     else if ( $ag_action == "edit" && $submit == "" )   $button_text = "Edit Alert Group";
     else if ( $ag_action == "edit" && $submit != "" )  
     {  $button_text = "Save Changes";  $ag_action = "save"; }
     else if ( $ag_action == "delete" && $submit == "" )  $button_text = "Delete Alert Group";
     else if ( $ag_action == "delete" && $submit != "" ) 
     {  $button_text = "Confirm Delete"; $ag_action = "delete_confirm";  }
     else if ( $ag_action == "clear" && $submit == "" )  $button_text = "Clear Alerts from Group";
     else if ( $ag_action == "clear" && $submit != "" ) 
     {  $button_text = "Confirm Clear"; $ag_action = "clear_confirm";  }

     echo '<INPUT TYPE="submit" NAME="submit" VALUE="'.$button_text.'">';

     echo '</FONT> </CENTER>';
   }

  echo '<INPUT TYPE="hidden" NAME="ag_action" VALUE="'.$ag_action.'">';

  if ( $ag_action == "view" && $submit != "" )
  {
     /* Calculate the Number of Alerts */
     $cnt_sql = "SELECT count(ag_sid) FROM acid_ag_alert WHERE ag_id=".$ag_id;

     $save_sql = "SELECT acid_event.sid, acid_event.cid, signature, timestamp, ".
                  "ip_src, ip_dst, ip_proto ".
                  "FROM acid_event ".
                  "LEFT JOIN acid_ag_alert ON acid_event.sid=ag_sid AND acid_event.cid=ag_cid ".
                  "WHERE acid_event.cid > 0 AND ag_id = ".$ag_id;

     $printing_ag = true;
     $ag = $ag_id;
     include("acid_qry_sqlcalls.php");
  }
  }

  $qs->SaveState();
 
  /* Export action_arg = current AG ID, so that Actions work */
  ExportHTTPVar("action_arg", $ag_id);
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>
