/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat;

import com.adobe.acrobat.AppleAboutDialog;
import com.adobe.acrobat.BeanClientTransactionExecutionContext;
import com.adobe.acrobat.PDFBookmark;
import com.adobe.acrobat.RenderingObserver;
import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.MemByteArraySource;
import com.adobe.acrobat.file.URLByteArraySourceSpace;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.LicAgreement;
import com.adobe.acrobat.gui.PrintUI;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.TerminalErrorDialog;
import com.adobe.acrobat.gui.ViewerFrame;
import com.adobe.acrobat.gui.ViewerPanel;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.VPageTextWordy;
import com.adobe.acrobat.pdf.Wordy;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.util.FontCache;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.util.ImageUtil;
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import netscape.security.PrivilegeManager;

public class Viewer
extends Applet
implements RenderingObserver,
ViewerCommand {
    private String pluginSuppliedURL = null;
    private AcroViewContext context = null;
    private static boolean asApplication = false;
    private static int registeredWindows = 0;
    private ViewerPanel viewerPanel = null;
    private boolean createCache = true;
    private static boolean enableDebug = false;
    private Frame parentFrame;
    private BeanClientTransactionExecutionContext beanExContext = new BeanClientTransactionExecutionContext();
    static final int kStartApplication = 1;
    static final int kStartApplet = 2;
    static final int kNewWindow = 3;
    static final int kActivate = 4;
    static final int kActivateWithoutBars = 5;
    private String[][] parameterInfo;
    private boolean pageRenderingDone;
    private RenderingObserver client;
    private Properties urlProperties_;

    public Viewer() throws Exception {
        this.setCacheFiles(true);
        this.createViewer();
        this.postLicAgreement();
        this.setBackground(ViewerPanel.getDesktopColor());
    }

    public Viewer(boolean bl) throws Exception {
        this.setCacheFiles(bl);
        this.createViewer();
        this.postLicAgreement();
        this.setBackground(ViewerPanel.getDesktopColor());
    }

    public Viewer(String[] stringArray) throws Exception {
        CommandRegistry.setDisallowedCommands(stringArray);
        this.createViewer();
    }

    public void activate() throws Exception {
        ViewerTransactor viewerTransactor = new ViewerTransactor(this, 4, null);
        viewerTransactor.commit();
    }

    private void activate(Transaction transaction) throws Exception {
        if (this.viewerPanel == null) {
            ImageUtil.registerRootComponent(this);
            this.setLayout(new BorderLayout());
            this.viewerPanel = new ViewerPanel(this.context);
            this.add((Component)this.viewerPanel, "Center");
            this.viewerPanel.synchVisibilityState();
            this.initFontCache(this.getFrame());
        }
    }

    public void activateWithoutBars() throws Exception {
        ViewerTransactor viewerTransactor = new ViewerTransactor(this, 5, null);
        viewerTransactor.commit();
    }

    private void activateWithoutBars(Transaction transaction) throws Exception {
        if (this.viewerPanel == null) {
            ImageUtil.registerRootComponent(this);
            this.setLayout(new BorderLayout());
            this.viewerPanel = new ViewerPanel(this.context);
            this.viewerPanel.removeToolbar();
            this.viewerPanel.removeStatusbar();
            this.add((Component)this.viewerPanel, "Center");
            this.initFontCache(this.getFrame());
        }
    }

    private void createViewer() throws Exception {
        Log.clog("* Viewer()");
        ReaderPrefs.setCacheFiles(this.getCacheFiles());
        ReaderPrefs.initialize();
        PDFFont.initPDFFont();
        Transaction transaction = new Transaction();
        transaction.begin(null);
        this.context = new AcroViewContext(transaction);
        transaction.finish();
        Log.clog("Viewer - context created.");
        String[] stringArray = new String[]{"EditCut", "EditDelete", "EditPaste", "EditUndo"};
        this.setDisallowedCommands(stringArray);
    }

    public void deactivate() {
        ImageUtil.unregisterRootComponent(this);
        ReaderPrefs.writePrefs();
    }

    private static String decode(String string) {
        String string2 = "";
        try {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.charAt(n);
                if (n2 == 37) {
                    String string3 = string.substring(n, n + 3);
                    if (string3.equals("%28")) {
                        n2 = 40;
                    } else if (string3.equals("%29")) {
                        n2 = 41;
                    } else if (string3.equalsIgnoreCase("%3D")) {
                        n2 = 61;
                    } else if (string3.equalsIgnoreCase("%2E")) {
                        n2 = 46;
                    } else if (string3.equalsIgnoreCase("%2F")) {
                        n2 = 47;
                    } else if (string3.equalsIgnoreCase("%3F")) {
                        n2 = 63;
                    } else if (string3.equalsIgnoreCase("%3A")) {
                        n2 = 58;
                    }
                    n += 3;
                } else {
                    ++n;
                }
                string2 = String.valueOf(string2) + (char)n2;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public void destroy() {
        this.deactivate();
        super.destroy();
    }

    public static boolean enabledDebug() {
        return enableDebug;
    }

    public void execMenuItem(String string) throws Exception {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalTopLevelWindow");
        }
        CommandRegistry.executeCommand(this.beanExContext, this.context, string);
    }

    public String getAppletInfo() {
        return Util.getDialogString("Main:ViewerInfo");
    }

    private boolean getCacheFiles() {
        return this.createCache;
    }

    public URL getCodeBase() {
        URL uRL = null;
        if (asApplication) {
            try {
                uRL = new URL(Session.getTheSession().getApplicationBaseURLAsString());
            }
            catch (Exception exception) {}
        } else {
            uRL = super.getCodeBase();
        }
        return uRL;
    }

    public AcroViewContext getContext() {
        return this.context;
    }

    public int getCurrentPage() throws Exception {
        if (this.context != null) {
            return this.context.getPageView().getCurrentPage(null);
        }
        return 0;
    }

    public String getDocumentURL() throws Exception {
        PDFObjStore pDFObjStore = this.context.getPDFObjStore(null);
        if (pDFObjStore == null) {
            return "";
        }
        ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(null);
        if (byteArray == null) {
            return "";
        }
        ByteArraySource byteArraySource = byteArray.getByteArraySource();
        if (byteArraySource != null) {
            return byteArraySource.getURL().toString();
        }
        return "";
    }

    public Frame getFrame() {
        if (this.parentFrame == null) {
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            this.parentFrame = (Frame)container;
        }
        return this.parentFrame;
    }

    public int getPageCount() throws Exception {
        if (this.context != null) {
            return this.context.getPageView().getNumPages(null);
        }
        return 0;
    }

    public String[][] getParameterInfo() {
        if (this.parameterInfo == null) {
            String[][] stringArrayArray = new String[][]{{"SRC", "URL", Util.getDialogString("Main:SRCparam")}};
            this.parameterInfo = stringArrayArray;
        }
        return this.parameterInfo;
    }

    public Properties getProperties() throws Exception {
        return ReaderPrefs.getClientProperties();
    }

    public String getProperty(String string) throws Exception {
        return this.getProperties().getProperty(string);
    }

    public PDFBookmark getRootBookmark() throws Exception {
        Requester requester = new Requester();
        try {
            PDFBookmark pDFBookmark = new PDFBookmark(this.getContext().getPDFObjStore(requester));
            Object var4_3 = null;
            requester.releaseRequestees();
            return pDFBookmark;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            requester.releaseRequestees();
            throw throwable;
        }
    }

    public String getTextForPage(int n) throws Exception {
        String string = "";
        if (this.context.hasPermission(null, "Copy")) {
            PDFReference pDFReference = this.context.getPageView().getPageRef(n, null);
            Wordy wordy = VPageTextWordy.getVPageTextWordy(pDFReference).wordyValue(null);
            string = wordy.getTextBuffer().toString().replace('\ufeff', ' ');
        }
        return string;
    }

    private String getUrlProperty(String string, String string2) {
        return this.urlProperties_ == null ? string2 : this.urlProperties_.getProperty(string, string2);
    }

    public void gotoNamedDest(String string) throws Exception {
        if (this.context != null) {
            final byte[] byArray = Util.rawBytesFromString(string);
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    GoToActionHandler.goToDest(transaction, new PDFString(byArray), context);
                }
            };
            transactor.commit(this.beanExContext);
        }
    }

    public void init() {
        ViewerTransactor viewerTransactor = new ViewerTransactor(this, 2, null);
        try {
            viewerTransactor.commit();
            this.runViewerApplet();
        }
        catch (Exception exception) {
            new ErrorDialog(this.getFrame(), exception);
        }
    }

    private void initFontCache(Frame frame) throws Exception {
        FontCache fontCache = FontCache.getTheFontCache();
        fontCache.setCacheFiles(this.getCacheFiles());
        fontCache.buildCache(false);
        fontCache.setReporterFrame(frame);
    }

    public static void main(String[] stringArray) {
        ViewerTransactor viewerTransactor = new ViewerTransactor(null, 1, stringArray);
        try {
            viewerTransactor.commit();
            if (viewerTransactor.viewer != null) {
                viewerTransactor.viewer.showFileDialog();
            }
        }
        catch (Exception exception) {
            new TerminalErrorDialog(exception, true);
        }
    }

    public Viewer openNewWindow() throws Exception {
        ViewerTransactor viewerTransactor = new ViewerTransactor(null, 3, null);
        viewerTransactor.commit();
        return viewerTransactor.viewer;
    }

    private void postLicAgreement() throws Exception {
        if (!ReaderPrefs.hasUserAcceptedLicAgreement()) {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalTopLevelWindow");
            }
            LicAgreement licAgreement = new LicAgreement(new Frame());
            licAgreement.setVisible(true);
        }
    }

    public void printAll() throws Exception {
        if (this.context != null) {
            this.printPages(1, this.getPageCount());
        }
    }

    public void printPages(final int n, final int n2) throws Exception {
        if (this.context != null) {
            final Properties properties = new Properties();
            ((Hashtable)properties).put("AcrobatSilentPrint", "true");
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    PrintUI.printPages(transaction, context, properties, n, n2);
                }
            };
            transactor.commit(this.beanExContext);
        }
    }

    public static synchronized void registerViewerWindow(Frame frame) {
        ++registeredWindows;
    }

    public synchronized void renderPage(final int n) throws Exception {
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                context.getPageView().goToPage(transaction, n);
            }
        };
        transactor.commit(this.beanExContext);
        this.pageRenderingDone = false;
        this.viewerPanel.getGalleyView().setRenderingObserver(this);
        while (!this.pageRenderingDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.pageRenderingDone = true;
        this.viewerPanel.getGalleyView().setRenderingObserver(null);
        this.beanExContext.throwLastException();
        if (this.client != null) {
            this.client.renderingDone();
        }
    }

    public synchronized void renderingDone() {
        this.pageRenderingDone = true;
        this.notifyAll();
    }

    private void runViewerApplet() throws Exception {
        this.setHelpFile();
        String string = this.getUrlProperty("MIME", this.getParameter("MIME"));
        boolean bl = string != null && string.equalsIgnoreCase("uninstall");
        String string2 = this.getUrlProperty("SRC", this.getParameter("SRC"));
        if (string2 != null && string2.trim().length() == 0) {
            string2 = null;
        }
        if (this.pluginSuppliedURL != null) {
            string2 = this.pluginSuppliedURL;
        }
        if (string2 == null) {
            this.setDocumentInputStream(Util.getResourceAsStream("welcome.pdf"));
        } else {
            this.setDocumentURL(string2);
        }
    }

    private void setByteArraySource(TransactionExecutionContext transactionExecutionContext, final AcroViewContext acroViewContext, final ByteArraySource byteArraySource) throws Exception {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                acroViewContext.setByteArraySource(transaction, byteArraySource);
            }
        };
        transactor.commit(transactionExecutionContext);
    }

    private void setCacheFiles(boolean bl) {
        this.createCache = bl;
    }

    private void setDisallowedCommands(String[] stringArray) throws Exception {
        CommandRegistry.setDisallowedCommands(stringArray);
    }

    public void setDocumentByteArray(byte[] byArray) throws Exception {
        MemByteArraySource memByteArraySource = new MemByteArraySource(byArray);
        this.setByteArraySource(this.beanExContext, this.context, memByteArraySource);
    }

    public void setDocumentByteArraySource(ByteArraySource byteArraySource) throws Exception {
        this.setByteArraySource(this.beanExContext, this.context, byteArraySource);
    }

    public void setDocumentInputStream(InputStream inputStream) throws Exception {
        this.setDocumentByteArray(Util.readStreamIntoByteArray(inputStream));
    }

    public void setDocumentURL(String string) throws Exception {
        boolean bl = true;
        try {
            this.getAppletContext();
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        URL uRL = bl ? new URL(this.getDocumentBase(), string) : new URL(string);
        Log.clog("setDocumentURL: " + uRL.toString());
        ByteArraySource byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL);
        this.setByteArraySource(this.beanExContext, this.context, byteArraySource);
    }

    public static void setEnableDebug(boolean bl) {
        enableDebug = bl;
    }

    private void setFrame(Frame frame) {
        this.parentFrame = frame;
    }

    private void setHelpFile() throws Exception {
        URL uRL;
        String string = ReaderPrefs.fHelpFileURL.trim();
        if (string.equals("help.pdf") && (uRL = this.getCodeBase()) != null) {
            uRL = new URL(uRL, "help.pdf");
            ReaderPrefs.fHelpFileURL = uRL.toExternalForm();
        }
    }

    private void setProperties(Transaction transaction, Hashtable hashtable) throws Exception {
        ReaderPrefs.setClientProperties(transaction, hashtable);
    }

    public void setProperty(final String string, final String string2) throws Exception {
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                Hashtable<String, String> hashtable = new Hashtable<String, String>(2, 1.0f);
                hashtable.put(string, string2);
                this.setProperties(transaction, hashtable);
            }
        };
        transactor.commit(this.beanExContext);
    }

    public synchronized void setRenderingObserver(RenderingObserver renderingObserver) {
        this.client = renderingObserver;
    }

    private void setUrlProperties(URL uRL) {
        block6: {
            Object object;
            String string;
            if (uRL == null) {
                Log.clog("setUrlProperties URL property is null");
                return;
            }
            String string2 = uRL.getRef();
            String string3 = string = string2 != null ? Viewer.decode(string2) : null;
            if (string == null || string.trim().length() <= 0) {
                object = uRL.getFile();
                int n = ((String)object).lastIndexOf(63);
                if (object != null && n != -1) {
                    string = ((String)object).substring(n + 1);
                }
            }
            if (string == null) break block6;
            object = new StringTokenizer(string, "&");
            StringBuffer stringBuffer = new StringBuffer();
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append(((StringTokenizer)object).nextToken()).append("\r\n");
            }
            try {
                this.urlProperties_ = new Properties();
                this.urlProperties_.load(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
            }
            catch (Exception exception) {
                this.urlProperties_ = null;
            }
        }
    }

    void showFileDialog() throws Exception {
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                boolean bl = SimpleUIVerb.getVDocIsOpenBoolean(Viewer.this.context).booleanValue(transaction);
                if (ReaderPrefs.fShowOpenDialogOnStartup.booleanValue(transaction) && !bl) {
                    EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    Component component = Viewer.this.context.getPageView().getDisplayComponent();
                    if (component != null) {
                        component = component.getParent();
                    }
                    KeyEvent keyEvent = CommandRegistry.makeKeyEvent(component, "Open");
                    if (component != null && eventQueue != null && keyEvent != null) {
                        eventQueue.postEvent(keyEvent);
                    }
                }
            }
        };
        transactor.commit(this.context);
    }

    private void startViewerApplet(Transaction transaction) throws Exception {
        Log.clog("* Viewer.init");
        this.initFontCache(this.getFrame());
        ReaderPrefs.setEnableProxySettings(false);
        this.setUrlProperties(this.getDocumentBase());
        if (!ReaderPrefs.hasUserAcceptedLicAgreement()) {
            this.add((Component)new Label("Sorry you must accept the Lic. agreement; otherwise you cannot run this applet"), "Center");
            return;
        }
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"Netcaster");
        }
        String string = this.getUrlProperty("DEBUG", this.getParameter("DEBUG"));
        Viewer.setEnableDebug(string != null);
        if (this.getUrlProperty("TOP", this.getParameter("TOP")) != null) {
            ViewerFrame viewerFrame = new ViewerFrame(this.getContext(), transaction);
            viewerFrame.show();
        } else {
            this.activate();
        }
    }

    private static Viewer startViewerApplication(Transaction transaction, String[] stringArray) throws Exception {
        Object object;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-r")) {
                if (++n < stringArray.length) {
                    string3 = stringArray[n];
                } else {
                    Viewer.usage();
                }
            } else if (stringArray[n].equalsIgnoreCase("-g")) {
                if (++n < stringArray.length) {
                    string2 = stringArray[n];
                } else {
                    Viewer.usage();
                }
            } else if (stringArray[n].equalsIgnoreCase("-nocache")) {
                bl4 = false;
            } else if (stringArray[n].equalsIgnoreCase("-d")) {
                bl = true;
            } else if (stringArray[n].equalsIgnoreCase("-v")) {
                bl2 = true;
            } else if (stringArray[n].equalsIgnoreCase("-console")) {
                bl3 = true;
            } else if (stringArray[n].equalsIgnoreCase("-MIMEUninstall")) {
                bl5 = true;
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        Util.setBaseResourceDirectory(string3);
        Viewer.setEnableDebug(bl);
        Log.openLog(string2);
        com.adobe.util.Log.setVerboseLogging(bl2);
        com.adobe.util.Log.setDebugLogging(bl);
        com.adobe.util.Log.setConsole(bl3);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Log.clog(String.valueOf(stringArray[n2]) + " : " + n2);
            ++n2;
        }
        Log.clog(string);
        Log.clog("*** Viewer.main ***");
        ReaderPrefs.setEnableProxySettings(true);
        Viewer viewer = new Viewer(bl4);
        ViewerFrame viewerFrame = new ViewerFrame(viewer.getContext(), transaction);
        if (Session.getTheSession().isMacOS() && MRJApplicationUtils.isMRJToolkitAvailable()) {
            object = new AppleAboutDialog(viewerFrame);
            MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)object);
        }
        viewer.setFrame(viewerFrame);
        viewer.initFontCache(viewerFrame);
        viewer.setHelpFile();
        if (ReaderPrefs.hasUserAcceptedLicAgreement()) {
            viewerFrame.show();
            if (string != null && !string.trim().equalsIgnoreCase("null")) {
                if (string.startsWith("http:") || string.startsWith("file:") || string.startsWith("ftp:")) {
                    viewer.setDocumentURL(string);
                } else {
                    try {
                        viewer.setDocumentInputStream(new FileInputStream(string));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        new ErrorDialog((Frame)viewerFrame, "File '" + string + "' not found.");
                    }
                }
            } else {
                object = Util.getResourceAsStream("splash.pdf");
                if (object != null) {
                    viewer.setDocumentInputStream((InputStream)object);
                }
            }
        } else {
            viewerFrame.close(transaction);
            return null;
        }
        asApplication = true;
        return viewer;
    }

    public static synchronized void unregisterViewerWindow(Frame frame) {
        if (--registeredWindows == 0) {
            if (ReaderPrefs.hasUserAcceptedLicAgreement()) {
                ReaderPrefs.writePrefs();
            }
            if (ReaderPrefs.getEnableProxySettings()) {
                System.exit(0);
            }
        }
    }

    private static void usage() {
        System.out.println("usage: com.adobe.acrobat.Viewer [-d]  [-r base-directory-of-resources] [-g log-file] [url-to-a-pdf-file-or-absolute-path-name]");
        System.out.println("Options '-d', '-g, and '-r' are for debugging only");
        System.exit(1);
    }

    public void zoomTo(double d) throws Exception {
        final double d2 = d;
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                Viewer.this.context.getPageView().setScale(transaction, (float)d2);
            }
        };
        transactor.commit(this.context);
    }

    static class ViewerTransactor
    extends Transactor {
        private int selector;
        private String[] args;
        Viewer viewer = null;

        ViewerTransactor(Viewer viewer, int n, String[] stringArray) {
            this.viewer = viewer;
            this.selector = n;
            this.args = stringArray;
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            switch (this.selector) {
                case 1: {
                    this.viewer = Viewer.startViewerApplication(transaction, this.args);
                    break;
                }
                case 2: {
                    this.viewer.startViewerApplet(transaction);
                    break;
                }
                case 3: {
                    this.viewer = new Viewer();
                    this.viewer.activate();
                    ViewerFrame viewerFrame = new ViewerFrame(this.viewer.context, this.viewer.viewerPanel, (Requester)transaction);
                    this.viewer.setFrame(viewerFrame);
                    viewerFrame.show();
                    break;
                }
                case 4: {
                    this.viewer.activate(transaction);
                    break;
                }
                case 5: {
                    this.viewer.activateWithoutBars(transaction);
                }
            }
        }
    }
}

