/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.pdfobjstore.PDFName;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.util.Assert;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class InspectorCell
extends Canvas
implements VObserver,
StrobeContainer {
    protected static final int kFontSize = 11;
    protected static Font boldFont = new Font("Helvetica", 1, 11);
    protected static Font italicFont = new Font("Helvetica", 2, 11);
    protected static Font plainFont = new Font("Helvetica", 0, 11);
    protected static final int kCellInset = 2;
    protected static final int kArrowWidth = 5;
    private boolean selected;
    private VStrobe strobe;
    private int type;
    private String ref;
    private String val;
    int index;
    PDFObj obj;

    InspectorCell(int n, String string, PDFObj pDFObj) throws Exception {
        this.ref = string;
        this.obj = pDFObj;
        Assert.notFalse(pDFObj != null);
        this.index = n;
        this.selected = false;
        this.setBackground(Color.white);
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            this.val = this.peObjToString(this.obj, requester);
            this.type = this.obj.type(requester);
            this.repaint();
            Assert.notFalse(this.obj != null);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            Log.clog("InspectorCell.change: " + exception.toString());
        }
    }

    protected void drawPDFObj(Graphics graphics, String string) throws Exception {
        Assert.notFalse(this.obj != null);
        boolean bl = this.type == 6 || this.type == 7;
        Font font = bl ? italicFont : plainFont;
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent();
        int n3 = this.getSize().width - n - 2 - (bl ? 7 : 0);
        graphics.drawString(string, this.getSize().width - n - 2, 2 + n2);
    }

    protected void drawRef(Graphics graphics, String string) {
        graphics.setFont(boldFont);
        int n = this.getFontMetrics(boldFont).getAscent();
        graphics.drawString(string, 2, 2 + n);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.ref == null || this.val == null) {
                return;
            }
            if (this.selected) {
                graphics.setColor(Color.green);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                graphics.setColor(Color.black);
            }
            this.drawRef(graphics, this.ref);
            this.drawPDFObj(graphics, this.val);
        }
        catch (Exception exception) {
            Log.clog("DictEntryCell.paint: " + exception.toString());
        }
    }

    private String peObjToString(PDFObj pDFObj, Requester requester) throws Exception {
        int n = pDFObj.type(requester);
        if (n == 6) {
            return "<<dict>>";
        }
        if (n == 7) {
            return "<<array>>";
        }
        if (pDFObj instanceof PDFReference) {
            pDFObj = ((PDFReference)pDFObj).resolve(requester);
        }
        if (pDFObj instanceof PDFString) {
            return "(" + pDFObj.toString() + ")";
        }
        if (pDFObj instanceof PDFName) {
            return "/" + pDFObj.toString();
        }
        return pDFObj.toString();
    }

    void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            this.repaint();
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

