/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.bytearray.MemByteArray;
import com.adobe.acrobat.debug.ASCIIStreamView;
import com.adobe.acrobat.debug.HexStreamView;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.PEFrame;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VStreamFactory;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class PDFStreamInspector
extends Panel
implements ItemListener,
ActionListener {
    private boolean asciiViewDone = false;
    private VStreamFactory vFactory;
    private PDFReference pdfRef;
    boolean showingAscii = true;
    ASCIIStreamView asciiView;
    HexStreamView hexView;
    private Checkbox asciiBox;
    private Checkbox hexBox;
    private Button updateButton;
    private Panel cardPanel;
    private CardLayout cardLayout;

    public PDFStreamInspector(VStreamFactory vStreamFactory, PDFReference pDFReference) throws Exception {
        this.vFactory = vStreamFactory;
        this.pdfRef = pDFReference;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.asciiBox = new Checkbox("ASCII", checkboxGroup, true);
        this.hexBox = new Checkbox("Hex", checkboxGroup, false);
        this.updateButton = new Button("Update");
        panel.add(this.asciiBox);
        panel.add(this.hexBox);
        panel.add(this.updateButton);
        this.add((Component)panel, "North");
        this.asciiBox.addItemListener(this);
        this.hexBox.addItemListener(this);
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(this);
        this.cardPanel = new Panel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.add((Component)this.cardPanel, "Center");
        this.asciiView = new ASCIIStreamView(vStreamFactory, this);
        this.cardPanel.add((Component)this.asciiView, "ASCII");
        this.hexView = new HexStreamView(vStreamFactory);
        this.cardPanel.add((Component)this.hexView, "Hex");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Transactor transactor = new Transactor(){

                protected final void buildChanges(Transaction transaction) throws Exception {
                    PDFDict pDFDict = PDFStreamInspector.this.pdfRef.dictValue(transaction);
                    String string = PDFStreamInspector.this.asciiView.getText();
                    byte[] byArray = string.getBytes();
                    MemByteArray memByteArray = new MemByteArray(byArray);
                    String[] stringArray = new String[]{"Filter", "Length"};
                    PDFObj[] pDFObjArray = new PDFObj[]{null, new PDFInteger(byArray.length)};
                    PDFDict pDFDict2 = new PDFDict(pDFDict, stringArray, pDFObjArray, true, memByteArray, 0);
                    PDFStreamInspector.this.pdfRef.setReferent(transaction, pDFDict2);
                }
            };
            transactor.commit();
        }
        catch (Exception exception) {
            Log.clog("PDFStreamInspector.actionPerformed: " + exception.toString());
        }
    }

    void asciiViewDone(boolean bl) {
        this.asciiViewDone = bl;
        this.synchAsciiView();
    }

    public static Frame createPDFStreamInspectorWindow(VStreamFactory vStreamFactory, PDFReference pDFReference) throws Exception {
        PEFrame pEFrame = new PEFrame("Stream Inspector", true);
        PDFStreamInspector pDFStreamInspector = new PDFStreamInspector(vStreamFactory, pDFReference);
        pEFrame.add(pDFStreamInspector);
        ((Component)pEFrame).setBounds(0, 0, 600, 300);
        ((Component)pEFrame).setLocation(200, 150);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PDFStreamInspector.this.asciiView.killOwnerThread();
                PDFStreamInspector.this.hexView.killOwnerThread();
            }
        };
        pEFrame.addWindowListener(windowAdapter);
        return pEFrame;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.showingAscii = itemEvent.getItem().equals("ASCII");
            this.cardLayout.show(this.cardPanel, (String)itemEvent.getItem());
            this.synchAsciiView();
        }
    }

    private void synchAsciiView() {
        boolean bl = this.showingAscii && this.asciiViewDone && this.pdfRef != null;
        this.updateButton.setEnabled(bl);
        this.asciiView.setEditable(bl);
    }
}

