/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.FileByteArrayInputStream;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import netscape.security.PrivilegeManager;

class FileByteArray
extends ByteArray {
    private RandomAccessFile rf;

    public FileByteArray(RandomAccessFile randomAccessFile, ByteArraySource byteArraySource) {
        super(byteArraySource);
        this.rf = randomAccessFile;
    }

    protected int computeLength() throws IOException {
        return (int)this.rf.length();
    }

    protected InputStream createStream(ContiguousByteRange contiguousByteRange) throws IOException {
        return new FileByteArrayInputStream(contiguousByteRange, this.rf);
    }

    protected void fetchBytes(int n, byte[] byArray, int n2, int n3) throws IOException {
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            RandomAccessFile randomAccessFile = this.rf;
            synchronized (randomAccessFile) {
                this.rf.seek(n);
                this.rf.readFully(byArray, n2, n3);
            }
        }
        catch (Exception exception) {
            Log.clog("FileByteArraySourceSpace.fetchBytes(...)" + exception);
        }
    }
}

