/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.ByteArraySourceSpace;
import com.adobe.acrobat.file.URLByteArraySource;
import com.adobe.acrobat.gui.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;

public class URLByteArraySourceSpace
extends ByteArraySourceSpace {
    public static final String URL_K = "URL";

    public static ByteArraySource createURLByteArraySource(String string) throws MalformedURLException {
        return URLByteArraySourceSpace.createURLByteArraySource(new URL(string));
    }

    public static ByteArraySource createURLByteArraySource(URL uRL) throws MalformedURLException {
        return new URLByteArraySource(uRL);
    }

    public static ByteArraySource createURLByteArraySource(URL uRL, Authenticator authenticator) throws MalformedURLException {
        return new URLByteArraySource(uRL, authenticator);
    }

    public ByteArraySource getByteArraySourceAbsolute(String string) throws Exception {
        return new URLByteArraySource(new URL(ByteArraySourceSpace.toPlatformString(string, '/')));
    }

    public ByteArraySource getByteArraySourceRelative(String string, String string2) throws Exception {
        if (string == null || string2.charAt(0) == '/') {
            return this.getByteArraySourceAbsolute(string2);
        }
        URL uRL = new URL(string);
        return new URLByteArraySource(new URL(uRL, ByteArraySourceSpace.toPlatformString(string2, '/')));
    }

    public String getFileSpace() {
        return URL_K;
    }

    public static void init() {
        if (ByteArraySourceSpace.defaultSourceSpace == null) {
            ByteArraySourceSpace.defaultSourceSpace = new URLByteArraySourceSpace();
            ByteArraySourceSpace.registerByteArraySourceSpace(URL_K, ByteArraySourceSpace.defaultSourceSpace);
        }
    }
}

