/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.filters;

import com.adobe.acrobat.filters.DecodeInputStream;
import com.adobe.acrobat.filters.FilterParams;
import com.adobe.acrobat.filters.RC4Engine;
import java.io.IOException;
import java.io.InputStream;

public class RC4CmpatInputStream
extends DecodeInputStream {
    RC4Engine engine;
    long bytesToDecode;

    public RC4CmpatInputStream(InputStream inputStream, byte[] byArray) {
        this(inputStream, byArray, byArray.length);
    }

    public RC4CmpatInputStream(InputStream inputStream, byte[] byArray, int n) {
        this(inputStream, byArray, n, -1L, null);
    }

    public RC4CmpatInputStream(InputStream inputStream, byte[] byArray, int n, long l, FilterParams filterParams) {
        super(inputStream, 256, 256, 0, filterParams);
        this.engine = new RC4Engine(byArray, 0, n);
        this.bytesToDecode = l;
    }

    public void fill() {
        while (this.outCount < this.outBuf.length && this.bytesToDecode != 0L) {
            int n = this.outBuf.length - this.outCount;
            if (this.inCount <= this.inPos) {
                int n2 = this.inBuf.length;
                if (this.useInMark) {
                    this.in.mark(this.inBuf.length);
                } else if (n < n2) {
                    n2 = n;
                }
                this.inPos = 0;
                try {
                    this.inCount = this.in.read(this.inBuf, this.inPos, n2);
                }
                catch (IOException iOException) {
                    this.pendingException = iOException;
                    break;
                }
                if (this.inCount <= this.inPos) {
                    this.pendingEOF = true;
                    break;
                }
            }
            if (this.inCount - this.inPos < n) {
                n = this.inCount - this.inPos;
            }
            if (this.bytesToDecode > 0L && this.bytesToDecode < (long)n) {
                n = (int)this.bytesToDecode;
            }
            this.engine.cipher(this.inBuf, this.inPos, this.outBuf, this.outCount, n);
            this.inPos += n;
            this.outCount += n;
            if (this.bytesToDecode <= 0L) continue;
            this.bytesToDecode -= (long)n;
        }
    }
}

