/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.filters;

import com.adobe.acrobat.filters.DecodeInputStream;
import com.adobe.acrobat.filters.FilterDataFormatException;
import com.adobe.acrobat.filters.FilterParams;
import com.adobe.acrobat.filters.TIFFEngine;
import java.io.IOException;
import java.io.InputStream;

public class TIFFInputStream
extends DecodeInputStream {
    private TIFFEngine tiff;

    public TIFFInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public TIFFInputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 1, filterParams);
        this.tiff = new TIFFEngine(inputStream, filterParams);
    }

    public TIFFInputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 1, filterParams);
        this.tiff = new TIFFEngine(this, filterParams);
    }

    public void fill() {
        while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null) {
            if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                this.pendingEOF = true;
                break;
            }
            int n = this.inBuf[this.inPos++] & 0xFF;
            try {
                this.outBuf[this.outCount++] = (byte)this.tiff.TIFFPredict(n);
            }
            catch (IOException iOException) {
                this.pendingException = new FilterDataFormatException("TIFF error: " + iOException.getMessage());
                break;
            }
        }
    }

    int read1() {
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            this.pendingEOF = true;
            return -1;
        }
        return this.inBuf[this.inPos++] & 0xFF;
    }
}

