/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.gui.KeyBindings;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.QuickSort;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Vector;

class AddBinding
extends BasicDialog
implements ItemListener {
    private KeyBindings keyBindings;
    private String prefix;
    private String mainKey;
    private TextField shortcutKey;
    private Choice cmds;
    private Checkbox control;
    private Checkbox shift;
    private Label label;
    private Container cmd;
    private Container key;
    private Container mod;
    private Container main;
    private GridBagLayout gCmd;
    private GridBagLayout gKey;
    private GridBagLayout gMod;
    private GridBagLayout gMain;
    private GridBagConstraints cCmd;
    private GridBagConstraints cKey;
    private GridBagConstraints cMod;
    private GridBagConstraints cMain;

    public AddBinding(Frame frame, KeyBindings keyBindings) {
        super(frame, Util.getDialogString("KeyBinding:AddBinding:Title"), true);
        this.keyBindings = keyBindings;
        this.setLayout(new BorderLayout(5, 5));
        this.createGridPanels();
        this.createCommandElements();
        this.createKeyElements();
        this.label = new Label();
        this.label.setForeground(Color.blue);
        this.addRowFill(this.main, this.gMain, this.cMain, this.cmd, 1);
        this.addRowFill(this.main, this.gMain, this.cMain, this.key, 15);
        this.add((Component)this.main, "Center");
        this.add((Component)this.okCancelPanel, "East");
        this.add((Component)this.label, "South");
        this.ok.setEnabled(false);
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(2, 1, 5, 5));
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
    }

    private void clear() {
        this.label.setText("");
        this.shortcutKey.setText("");
        this.control.setState(false);
        this.shift.setState(false);
    }

    private void createCommandElements() {
        this.cmds = new Choice();
        this.getCommands();
        this.addRow(this.cmd, this.gCmd, this.cCmd, Util.getDialogString("KeyBinding:AddBinding:SelectCommand"), this.cmds);
    }

    private void createGridPanels() {
        this.cmd = new GroupBox(Util.getDialogString("KeyBinding:AddBinding:SelectCommandTitle"));
        this.gCmd = new GridBagLayout();
        this.cCmd = new GridBagConstraints();
        this.cmd.setLayout(this.gCmd);
        this.cCmd.insets = new Insets(1, 4, 1, 4);
        this.cCmd.fill = 1;
        this.mod = new GroupBox(Util.getDialogString("KeyBinding:AddBinding:SelectModifierTitle"));
        this.gMod = new GridBagLayout();
        this.cMod = new GridBagConstraints();
        this.mod.setLayout(this.gMod);
        this.cMod.insets = new Insets(1, 4, 1, 4);
        this.cMod.fill = 1;
        this.key = new GroupBox(Util.getDialogString("KeyBinding:AddBinding:SelectKeyTitle"));
        this.gKey = new GridBagLayout();
        this.cKey = new GridBagConstraints();
        this.key.setLayout(this.gKey);
        this.cKey.insets = new Insets(1, 4, 1, 4);
        this.cKey.fill = 1;
        this.main = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.main.setLayout(this.gMain);
        this.cMain.fill = 1;
    }

    private void createKeyElements() {
        this.control = new Checkbox(Util.getDialogString("KeyBinding:AddBinding:Control"), false);
        this.shift = new Checkbox(Util.getDialogString("KeyBinding:AddBinding:Shift"), false);
        this.control.addItemListener(this);
        this.shift.addItemListener(this);
        this.shortcutKey = new TextField(4);
        this.shortcutKey.addKeyListener(this);
        this.addRow(this.key, this.gKey, this.cKey, Util.getDialogString("KeyBinding:AddBinding:SelectKey"), this.shortcutKey);
    }

    private void getCommands() {
        try {
            Object object;
            Class<?> clazz = Class.forName("com.adobe.acrobat.ViewerCommand");
            Field[] fieldArray = clazz.getFields();
            Vector<Object[]> vector = new Vector<Object[]>();
            int n = 0;
            while (n < fieldArray.length) {
                object = (String)fieldArray[n].get(fieldArray[n]);
                if (CommandRegistry.isCommandAllowed((String)object)) {
                    vector.addElement((Object[])object);
                }
                ++n;
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            QuickSort.sort((String[])object, 0, ((Object[])object).length - 1);
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                this.cmds.add((String)object[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.logStackTrace(exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.prefix = this.control.getState() ? "Control+" : "";
        this.prefix = String.valueOf(this.prefix) + (this.shift.getState() ? "Shift+" : "");
        this.setLabel();
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getComponent() == this.shortcutKey && KeyBindings.isValidKey(keyEvent)) {
            String string = KeyBindings.getKeybindingText(keyEvent);
            this.mainKey = KeyBindings.getMainKeyText(string);
            this.shortcutKey.setText(this.mainKey);
            this.shortcutKey.selectAll();
            this.control.setState(keyEvent.isControlDown());
            this.shift.setState(keyEvent.isShiftDown());
            this.prefix = KeyBindings.getModifiersText(string);
            this.setLabel();
        }
        this.ok.setEnabled(this.shortcutKey.getText().length() > 0);
    }

    public void ok() {
        if (this.keyBindings.isShortcutAvailable(this.label.getText())) {
            this.keyBindings.addKeyBinding(this.cmds.getSelectedItem(), this.label.getText());
            super.ok();
        } else {
            new ErrorDialog(this.keyBindings.parent, Util.getDialogString("KeyBinding:AddBinding:DuplicateShortcutError"));
            this.clear();
        }
    }

    private void setLabel() {
        this.label.setText(this.mainKey.length() > 0 ? String.valueOf(this.prefix) + this.mainKey : "");
    }
}

