/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PVNavigation;
import com.adobe.acrobat.gui.PageView;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.notify.Transaction;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ScrollingMouseTransactionClient
implements MouseTransactionClient,
Runnable {
    private PageView pv;
    private Point grabPoint;
    Point dragRef;
    Point dragPoint;
    private Transaction dragTransaction;
    private boolean mouseDragsOccurred = false;
    private Thread clientThread;
    private long nextTickTime;
    private Exception autoException;

    ScrollingMouseTransactionClient(PageView pageView) {
        this.pv = pageView;
        this.clientThread = new Thread(this);
        this.nextTickTime = System.currentTimeMillis() + 0x1FFFFFFFFFFFFFFFL;
        this.dragPoint = new Point();
        this.clientThread.start();
    }

    public synchronized void mouseAborted(Transaction transaction) throws Exception {
        if (this.clientThread != null) {
            this.clientThread.stop();
            this.clientThread = null;
        }
        if (this.autoException != null) {
            throw this.autoException;
        }
    }

    public synchronized void mouseDragged(Transaction transaction, Point point) throws Exception {
        if (this.autoException != null) {
            throw this.autoException;
        }
        Rectangle rectangle = this.pv.getAperture(transaction);
        this.dragPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        this.dragTransaction = transaction;
        this.scrollTo(transaction, this.dragPoint);
        this.mouseDragsOccurred = true;
    }

    public synchronized void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        this.grabPoint = mouseEvent.getPoint();
        Rectangle rectangle = this.pv.getAperture(transaction);
        this.dragRef = new Point(this.grabPoint.x - rectangle.x, this.grabPoint.y - rectangle.y);
        this.dragPoint.setLocation(this.dragRef);
        this.mouseDragsOccurred = false;
        this.pv.suspendNavigation(transaction);
    }

    public synchronized void mouseReleased(Transaction transaction, Point point) throws Exception {
        this.mouseAborted(transaction);
        Rectangle rectangle = this.pv.getAperture(transaction);
        this.dragPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        this.scrollTo(transaction, this.dragPoint);
        if (!this.mouseDragsOccurred && point.equals(this.grabPoint)) {
            this.pv.setSelection(transaction, null);
        }
        this.pv.resumeNavigation(transaction);
    }

    public synchronized void run() {
        long l = this.nextTickTime - System.currentTimeMillis();
        try {
            while (this.autoException == null) {
                if (l > 0L) {
                    this.wait(l);
                }
                if ((l = this.nextTickTime - System.currentTimeMillis()) > 0L) continue;
                try {
                    this.nextTickTime = System.currentTimeMillis() + 0x1FFFFFFFFFFFFFFFL;
                    Rectangle rectangle = this.pv.getAperture(this.dragTransaction);
                    this.mouseDragged(this.dragTransaction, new Point(this.dragPoint.x + rectangle.x, this.dragPoint.y + rectangle.y));
                }
                catch (Exception exception) {
                    this.autoException = exception;
                }
                l = this.nextTickTime - System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void scrollTo(Transaction transaction, Point point) throws Exception {
        this.dragTransaction = transaction;
        if (this.autoException != null) {
            throw this.autoException;
        }
        Rectangle rectangle = this.pv.getAperture(transaction);
        int n = this.dragRef.x - point.x;
        int n2 = this.dragRef.y - point.y;
        if (n != 0 || n2 != 0) {
            PVNavigation.scrollTo(transaction, this.pv, new Point(rectangle.x + n, rectangle.y + n2));
        }
        this.dragRef.setLocation(point);
        long l = 0x1FFFFFFFFFFFFFFFL;
        if (this.dragRef.x < 0) {
            this.dragRef.x = 0;
            l = 200L;
        } else if (this.dragRef.x >= rectangle.width) {
            this.dragRef.x = rectangle.width - 1;
            l = 200L;
        }
        if (this.dragRef.y < 0) {
            this.dragRef.y = 0;
            l = 200L;
        } else if (this.dragRef.y >= rectangle.height) {
            this.dragRef.y = rectangle.height - 1;
            l = 200L;
        }
        this.nextTickTime = System.currentTimeMillis() + l;
        this.notifyAll();
        transaction.notifyStrobes();
    }
}

