/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.DocInfo;
import com.adobe.acrobat.gui.PrefsDialog;
import com.adobe.acrobat.gui.URLDialog;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Transaction;
import com.adobe.util.Assert;
import java.awt.Frame;

public abstract class TransactionDialog
extends BasicDialog {
    private static final String URLDialog_K = "URLDialog";
    private static final String DocInfo_K = "DocInfo";
    private static final String PrefsDialog_K = "PrefsDialog";
    private static ExtensionDataProvider provider = null;
    protected Transaction transaction;

    public TransactionDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    public static DocInfo getDocInfoDialog(AcroViewContext acroViewContext) {
        TransactionDialog.initProvider();
        return (DocInfo)acroViewContext.getExtensionData(DocInfo_K);
    }

    public static PrefsDialog getPrefsDialog(AcroViewContext acroViewContext) {
        TransactionDialog.initProvider();
        return (PrefsDialog)acroViewContext.getExtensionData(PrefsDialog_K);
    }

    public static URLDialog getURLDialog(AcroViewContext acroViewContext) {
        TransactionDialog.initProvider();
        return (URLDialog)acroViewContext.getExtensionData(URLDialog_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    AcroViewContext acroViewContext = (AcroViewContext)extensible;
                    if (string.equals(TransactionDialog.URLDialog_K)) {
                        return new URLDialog(acroViewContext);
                    }
                    if (string.equals(TransactionDialog.DocInfo_K)) {
                        return new DocInfo(acroViewContext);
                    }
                    if (string.equals(TransactionDialog.PrefsDialog_K)) {
                        return new PrefsDialog(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(URLDialog_K, provider);
            Extension.registerProvider(DocInfo_K, provider);
            Extension.registerProvider(PrefsDialog_K, provider);
        }
    }

    protected abstract void populate() throws Exception;

    public void show(Transaction transaction) throws Exception {
        TransactionDialog transactionDialog = this;
        synchronized (transactionDialog) {
            if (this.transaction != null) {
                Object var3_3 = null;
                return;
            }
            this.transaction = transaction;
        }
        this.populate();
        this.pack();
        StrobeUtils.setAllStrobesActive(transaction, this, true);
        transaction.notifyStrobes();
        this.setVisible(true);
        StrobeUtils.setAllStrobesActive(transaction, this, false);
        transactionDialog = this;
        synchronized (transactionDialog) {
            this.transaction = null;
        }
    }
}

