/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.GoToActionInfo;
import com.adobe.acrobat.pdf.VPageTreeNodeProps;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFName;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;

class VGoToActionInfo
extends VValue {
    private static final String VGoToActionInfo_K = "VGoToActionInfo";
    private static ExtensionDataProvider provider = null;
    public static final String GoTo_K = "GoTo";
    public static final String GoToR_K = "GoToR";
    public static final String D_K = "D";
    public static final String F_K = "F";
    private static final String FitR_K = "FitR";
    public static final String NewWindow_K = "NewWindow";
    private static final String N_K = "N";
    private static final String P_K = "P";
    private static final String R_K = "R";
    private static final String S_K = "S";
    private PDFReference pdfRef;
    private GoToActionInfo actionInfo;

    VGoToActionInfo(PDFReference pDFReference) {
        this.pdfRef = pDFReference;
    }

    protected final void compute(Requester requester) throws Exception {
        this.actionInfo = new GoToActionInfo();
        this.actionInfo.store = this.pdfRef.getObjStore();
        if (this.pdfRef.type(requester) == 6) {
            PDFDict pDFDict = this.pdfRef.dictValue(requester);
            String string = pDFDict.hasKey(S_K) ? pDFDict.get(S_K).nameValue(requester) : GoTo_K;
            PDFObj pDFObj = pDFDict.get(D_K);
            if (string.equals("Thread")) {
                pDFDict = pDFObj.dictValue(requester);
                pDFDict = pDFDict.get(F_K).dictValue(requester);
                PDFObj[] pDFObjArray = new PDFObj[6];
                pDFObjArray[0] = pDFDict.get(P_K);
                pDFObjArray[1] = new PDFName(FitR_K);
                PDFArray pDFArray = pDFDict.get(R_K).arrayValue(requester);
                pDFObjArray[2] = pDFArray.get(0);
                pDFObjArray[3] = pDFArray.get(1);
                pDFObjArray[4] = pDFArray.get(2);
                pDFObjArray[5] = pDFArray.get(3);
                this.actionInfo.destArray = new PDFArray(pDFObjArray);
            } else {
                GoToActionInfo goToActionInfo = GoToActionHandler.getActionInfo(string, this.pdfRef.getObjStore(), pDFObj, requester);
                if (goToActionInfo != null) {
                    this.actionInfo.destArray = goToActionInfo.destArray;
                    this.actionInfo.pageNumRelative = goToActionInfo.pageNumRelative;
                    this.actionInfo.pageNum = goToActionInfo.pageNum;
                    this.actionInfo.destName = goToActionInfo.destName;
                }
                if (string.equals(GoToR_K)) {
                    this.actionInfo.destObj = pDFDict.get(F_K);
                    if (pDFDict.hasKey(NewWindow_K)) {
                        this.actionInfo.newWindow = pDFDict.get(NewWindow_K).booleanValue(requester);
                    }
                }
            }
        } else if (this.pdfRef.type(requester) == 7) {
            this.actionInfo.destArray = this.pdfRef.arrayValue(requester);
            PDFObj pDFObj = this.actionInfo.destArray.get(0);
            if (pDFObj.type(requester) == 0) {
                this.actionInfo.pageNumRelative = true;
                this.actionInfo.pageNum = 0;
            } else if (pDFObj.type(requester) == 2) {
                this.actionInfo.pageNumRelative = false;
                this.actionInfo.pageNum = pDFObj.integerValue(requester);
            } else {
                PDFReference pDFReference = pDFObj.pdfReferenceValue(requester);
                VPageTreeNodeProps vPageTreeNodeProps = VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference);
                this.actionInfo.pageNumRelative = false;
                this.actionInfo.pageNum = vPageTreeNodeProps.numPagesBefore(requester);
            }
        } else {
            Assert.notFalse(false);
        }
    }

    static VGoToActionInfo getVGoToActionInfo(PDFReference pDFReference) {
        VGoToActionInfo.initProvider();
        return (VGoToActionInfo)pDFReference.getExtensionData(VGoToActionInfo_K);
    }

    GoToActionInfo goToActionInfoValue(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.actionInfo;
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    if (string.equals(VGoToActionInfo.VGoToActionInfo_K)) {
                        Assert.notFalse(extensible instanceof PDFReference);
                        return new VGoToActionInfo((PDFReference)extensible);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VGoToActionInfo_K, provider);
        }
    }

    static boolean vGoToActionInfoIsAvailable(PDFReference pDFReference) {
        return pDFReference.extensionDataIsAvailable(VGoToActionInfo_K);
    }
}

