/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PVNavigation;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ScrollingMouseTransactionClient;
import com.adobe.acrobat.gui.ZoomTool;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.notify.Transaction;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class ZoomMouseTransactionClient
extends ScrollingMouseTransactionClient {
    static final String FixedZoom_K = "FixedZoom";
    static int counter = 0;
    PageView pv;
    boolean zoomIn;
    Point startPt;
    VRectangle vZoomRectangle;

    ZoomMouseTransactionClient(PageView pageView, boolean bl) {
        super(pageView);
        this.pv = pageView;
        this.zoomIn = bl;
        this.vZoomRectangle = ZoomTool.getVZoomTrackingRectangle(pageView);
    }

    public void mouseAborted(Transaction transaction) throws Exception {
        super.mouseAborted(transaction);
        this.vZoomRectangle.setRectangleValue(transaction, null);
    }

    public void mouseDragged(Transaction transaction, Point point) throws Exception {
        Rectangle rectangle = this.pv.getAperture(transaction);
        this.dragPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        this.dragRef.setLocation(this.dragPoint);
        if (this.dragPoint.x < 0) {
            this.dragPoint.x = 0;
        } else if (this.dragPoint.x >= rectangle.width) {
            this.dragPoint.x = rectangle.width - 1;
        }
        if (this.dragPoint.y < 0) {
            this.dragPoint.y = 0;
        } else if (this.dragPoint.y >= rectangle.height) {
            this.dragPoint.y = rectangle.height - 1;
        }
        this.scrollTo(transaction, this.dragPoint);
        Rectangle rectangle2 = new Rectangle(Math.min(point.x, this.startPt.x), Math.min(point.y, this.startPt.y), Math.abs(point.x - this.startPt.x), Math.abs(point.y - this.startPt.y));
        this.vZoomRectangle.setRectangleValue(transaction, rectangle2);
        transaction.notifyStrobes();
    }

    public void mousePressed(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        super.mousePressed(transaction, mouseEvent);
        this.startPt = mouseEvent.getPoint();
        this.vZoomRectangle.setRectangleValue(transaction, new Rectangle(this.startPt.x, this.startPt.y, 0, 0));
        transaction.notifyStrobes();
    }

    public void mouseReleased(Transaction transaction, Point point) throws Exception {
        float f;
        float f2;
        boolean bl;
        super.mouseAborted(transaction);
        this.vZoomRectangle.setRectangleValue(transaction, null);
        float f3 = this.pv.getScale(transaction);
        Point point2 = new Point(point);
        Dimension dimension = this.pv.getApertureSize(transaction);
        boolean bl2 = bl = Math.abs(point.x - this.startPt.x) < 5 && Math.abs(point.y - this.startPt.y) < 5;
        if (bl) {
            f2 = this.zoomIn ? (float)((double)f3 * ZoomTool.defaultZoomRatio) : (float)((double)f3 / ZoomTool.defaultZoomRatio);
        } else {
            Rectangle rectangle = new Rectangle(Math.min(this.startPt.x, point.x), Math.min(this.startPt.y, point.y), Math.abs(point.x - this.startPt.x), Math.abs(point.y - this.startPt.y));
            point2.x = rectangle.x + rectangle.width / 2;
            point2.y = rectangle.y + rectangle.height / 2;
            float f4 = (float)dimension.width / (float)rectangle.width;
            f = (float)dimension.height / (float)rectangle.height;
            f2 = Math.min(f4, f);
            if (!this.zoomIn) {
                f2 = 1.0f / f2;
            }
            f2 *= f3;
        }
        int n = this.pv.findPage(point2, transaction);
        Rectangle rectangle = this.pv.getPageRectangle(n, transaction);
        if (rectangle != null) {
            point2.x -= rectangle.x;
            point2.y -= rectangle.y;
        }
        this.pv.setScale(transaction, f2);
        f2 = this.pv.getScale(transaction);
        f = f2 / f3;
        point2.x = Math.round(f * (float)point2.x) - dimension.width / 2;
        point2.y = Math.round(f * (float)point2.y) - dimension.height / 2;
        rectangle = this.pv.getPageRectangle(n, transaction);
        if (rectangle != null) {
            point2.x += rectangle.x;
            point2.y += rectangle.y;
        }
        PVNavigation.scrollTo(transaction, this.pv, point2);
    }
}

