/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.ByteArraySourceSpace;
import com.adobe.acrobat.file.StreamByteArraySource;
import com.adobe.acrobat.pdf.NameTree;
import com.adobe.acrobat.pdf.VNameTree;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;

public class FileSpec {
    private static final String F_K = "F";
    private static final String FS_K = "FS";
    private static final String EmbeddedFiles_K = "EmbeddedFiles";

    public static ByteArraySource getByteArraySource(PDFObj pDFObj, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
        ByteArraySource byteArraySource = byteArray.getByteArraySource();
        ByteArraySource byteArraySource2 = null;
        ByteArraySourceSpace byteArraySourceSpace = null;
        String string = null;
        if (pDFObj.type(requester) == 4) {
            string = pDFObj.stringValue(requester);
            byteArraySource2 = FileSpec.getEmbeddedFile(string, pDFObjStore, requester);
            if (byteArraySource2 == null) {
                byteArraySource2 = byteArraySource != null ? byteArraySource.getByteArraySourceRelative(string) : ByteArraySourceSpace.getDefaultSourceSpace().getByteArraySourceAbsolute(string);
            }
        } else if (pDFObj.type(requester) == 6) {
            String string2 = null;
            PDFDict pDFDict = pDFObj.dictValue(requester);
            if (byteArraySource != null && (byteArraySourceSpace = byteArraySource.getSourceSpace()) != null && (string2 = byteArraySourceSpace.getFileSpace()) != null && pDFDict.hasKey(string2) && (byteArraySource2 = FileSpec.getEmbeddedFile(string = pDFDict.get(string2).stringValue(requester), pDFObjStore, requester)) == null) {
                byteArraySource2 = byteArraySource.getByteArraySourceRelative(string);
            }
            if (byteArraySource2 == null && (byteArraySourceSpace = ByteArraySourceSpace.getDefaultSourceSpace()) != null && (string2 = byteArraySourceSpace.getFileSpace()) != null && pDFDict.hasKey(string2) && (byteArraySource2 = FileSpec.getEmbeddedFile(string = pDFDict.get(string2).stringValue(requester), pDFObjStore, requester)) == null) {
                byteArraySource2 = byteArraySourceSpace.getByteArraySourceRelative(string, byteArraySource, requester);
            }
            if (byteArraySource2 == null && pDFDict.hasKey(F_K) && (byteArraySource2 = FileSpec.getEmbeddedFile(string = pDFDict.get(F_K).stringValue(requester), pDFObjStore, requester)) == null) {
                if (pDFDict.hasKey(FS_K) && (byteArraySourceSpace = ByteArraySourceSpace.getByteArraySourceSpace(string2 = pDFDict.get(FS_K).nameValue(requester))) != null) {
                    byteArraySource2 = byteArraySourceSpace.getByteArraySourceRelative(string, byteArraySource, requester);
                }
                if (byteArraySource2 == null) {
                    byteArraySource2 = byteArraySource != null ? byteArraySource.getByteArraySourceRelative(string) : ByteArraySourceSpace.getDefaultSourceSpace().getByteArraySourceAbsolute(string);
                }
            }
        }
        return byteArraySource2;
    }

    private static ByteArraySource getEmbeddedFile(String string, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        StreamByteArraySource streamByteArraySource = null;
        VNameTree vNameTree = VNameTree.getVNameTreeNamed(pDFObjStore, EmbeddedFiles_K);
        NameTree nameTree = vNameTree.nameTreeValue(requester);
        if (nameTree != null) {
            VPDFObj vPDFObj = nameTree.getVPDFObjNamed(string);
            PDFReference pDFReference = vPDFObj.pdfObjValue(requester).pdfReferenceValue(requester);
            StreamFactory streamFactory = pDFReference.getFilteredVStreamFactory().streamFactoryValue(requester);
            streamByteArraySource = new StreamByteArraySource(string, pDFObjStore, streamFactory);
            return streamByteArraySource;
        }
        return null;
    }

    public static String getFileString(PDFObj pDFObj, Requester requester) throws Exception {
        if (pDFObj.type(requester) == 4) {
            return pDFObj.stringValue(requester);
        }
        if (pDFObj.type(requester) == 6) {
            PDFDict pDFDict = pDFObj.dictValue(requester);
            if (pDFDict.hasKey(F_K)) {
                return pDFDict.get(F_K).stringValue(requester);
            }
            return "?";
        }
        return "?";
    }
}

