/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.image.CalCMYKColorModel;
import com.adobe.acrobat.pdf.image.CalGrayColorModel;
import com.adobe.acrobat.pdf.image.CalRGBColorModel;
import com.adobe.acrobat.pdf.image.DeviceCMYKColorModel;
import com.adobe.acrobat.pdf.image.DeviceGrayColorModel;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.pdf.image.ImageMaskColorModel;
import com.adobe.acrobat.pdf.image.IndexedColorModel;
import com.adobe.acrobat.pdf.image.LabColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PatternColorModel;
import com.adobe.acrobat.pdf.image.SeparationColorModel;

public class PDFColorParams
implements Cloneable {
    private static final float[] defaultWhitePt = new float[]{0.9505f, 1.0f, 1.089f};
    private static final float[] defaultBlackPt = new float[3];
    private static final float[] defaultGamma = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] defaultDecode;
    private static final float[] reversedMaskDecode;
    private static final float[] defaultLabDecode;
    private static final float[] defaultRGBMatrix;
    private int bitsPerComponent;
    private int numComponents;
    private int colorSpace;
    private boolean interpolate;
    private float[] decode;
    private int[] alphaMask;
    private float[] whitePt;
    private float[] blackPt;
    private float[] gamma;
    private float[] rgbMatrix;
    private PDFColorModel baseModel;
    private int lookupHiVal;
    private byte[] indexLookup;
    private Function tintTransform;

    static {
        float[] fArray = new float[8];
        fArray[1] = 1.0f;
        fArray[3] = 1.0f;
        fArray[5] = 1.0f;
        fArray[7] = 1.0f;
        defaultDecode = fArray;
        float[] fArray2 = new float[2];
        fArray2[0] = 1.0f;
        reversedMaskDecode = fArray2;
        float[] fArray3 = new float[6];
        fArray3[1] = 1000.0f;
        fArray3[2] = -1000.0f;
        fArray3[3] = 1000.0f;
        fArray3[4] = -1000.0f;
        fArray3[5] = 1000.0f;
        defaultLabDecode = fArray3;
        float[] fArray4 = new float[9];
        fArray4[0] = 1.0f;
        fArray4[4] = 1.0f;
        fArray4[8] = 1.0f;
        defaultRGBMatrix = fArray4;
    }

    public PDFColorParams() {
    }

    public PDFColorParams(int n) {
        this.colorSpace = n;
    }

    public int Validate() {
        int n;
        boolean bl = false;
        switch (this.colorSpace) {
            case 6: {
                bl = true;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                this.numComponents = 1;
                break;
            }
            case 1: 
            case 4: {
                bl = true;
            }
            case 0: {
                this.numComponents = 3;
                break;
            }
            case 3: {
                bl = true;
            }
            case 2: {
                this.numComponents = 4;
                break;
            }
            case 10: {
                if (this.numComponents > 0) break;
                this.numComponents = 1;
                break;
            }
            case 11: {
                if (this.numComponents > 0) break;
                this.numComponents = 1;
                break;
            }
        }
        if (bl) {
            if (this.whitePt == null || this.whitePt.length < defaultWhitePt.length) {
                this.whitePt = defaultWhitePt;
            }
            if (this.blackPt == null || this.blackPt.length < defaultBlackPt.length) {
                this.blackPt = defaultBlackPt;
            }
            if (this.gamma == null) {
                this.gamma = defaultGamma;
            } else if (this.gamma.length == 1 && this.numComponents > 1) {
                float f = this.gamma[0];
                this.gamma = new float[this.numComponents];
                n = 0;
                while (n < this.numComponents) {
                    this.gamma[n] = f;
                    ++n;
                }
            } else if (this.gamma.length < this.numComponents) {
                this.gamma = defaultGamma;
            }
        } else {
            this.whitePt = null;
            this.blackPt = null;
        }
        if (this.colorSpace == 4) {
            if (this.decode == null || this.decode.length < defaultLabDecode.length) {
                this.decode = defaultLabDecode;
            }
        } else if (this.decode != null) {
            if (this.decode.length == 2 && this.numComponents > 1) {
                float[] fArray = this.decode;
                this.decode = new float[2 * this.numComponents];
                n = 0;
                while (n < this.numComponents) {
                    this.decode[2 * n] = fArray[0];
                    this.decode[2 * n + 1] = fArray[1];
                    ++n;
                }
            } else if (this.decode.length < 2 * this.numComponents) {
                this.decode = null;
            }
        }
        if (this.colorSpace == 1 && (this.rgbMatrix == null || this.rgbMatrix.length < defaultRGBMatrix.length)) {
            this.rgbMatrix = defaultRGBMatrix;
        }
        if (this.colorSpace == 8) {
            if (this.bitsPerComponent == 0) {
                this.bitsPerComponent = 1;
            }
            if (this.decode == null || this.decode.length < reversedMaskDecode.length) {
                this.decode = reversedMaskDecode;
            }
        }
        if (this.colorSpace == 9 && (this.decode == null || this.decode.length < reversedMaskDecode.length)) {
            this.decode = reversedMaskDecode;
        }
        if (this.colorSpace == 21) {
            if (this.baseModel == null) {
                this.baseModel = new DeviceGrayColorModel();
            }
            this.numComponents = this.baseModel.getNumComponents();
        }
        if (this.alphaMask != null && this.alphaMask.length < 2 * this.numComponents) {
            this.alphaMask = null;
        }
        if (this.bitsPerComponent == 0) {
            this.bitsPerComponent = 8;
        }
        return this.bitsPerComponent * this.numComponents;
    }

    public int[] getAlphaMask() {
        int[] nArray = null;
        if (this.alphaMask != null) {
            nArray = new int[2 * this.numComponents];
            int n = (1 << this.bitsPerComponent) - 1;
            int n2 = 0;
            while (n2 < 2 * this.numComponents) {
                nArray[n2] = this.alphaMask[n2] & n;
                switch (this.bitsPerComponent) {
                    case 1: {
                        int n3 = n2;
                        nArray[n3] = nArray[n3] + (nArray[n2] << 1);
                    }
                    case 2: {
                        int n4 = n2;
                        nArray[n4] = nArray[n4] + (nArray[n2] << 2);
                    }
                    case 4: {
                        int n5 = n2;
                        nArray[n5] = nArray[n5] + (nArray[n2] << 4);
                        break;
                    }
                }
                ++n2;
            }
        }
        return nArray;
    }

    public PDFColorModel getBaseModel() {
        return this.baseModel;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public float[] getBlackPt() {
        return this.blackPt;
    }

    public PDFColorModel getColorModel() {
        this.Validate();
        switch (this.colorSpace) {
            case 0: {
                return new DeviceRGBColorModel(this);
            }
            case 1: {
                return new CalRGBColorModel(this);
            }
            case 2: {
                return new DeviceCMYKColorModel(this);
            }
            case 3: {
                return new CalCMYKColorModel(this);
            }
            case 4: {
                return new LabColorModel(this);
            }
            case 20: {
                return new IndexedColorModel(this);
            }
            case 7: 
            case 8: 
            case 9: {
                this.colorSpace = 7;
                return new ImageMaskColorModel(this);
            }
            case 5: {
                return new DeviceGrayColorModel(this);
            }
            case 6: {
                return new CalGrayColorModel(this);
            }
            case 21: {
                return new PatternColorModel(this);
            }
            case 10: {
                return new SeparationColorModel(this);
            }
        }
        return null;
    }

    public float[] getDecode() {
        return this.decode;
    }

    public float[] getGamma() {
        return this.gamma;
    }

    public int getHiVal() {
        return this.lookupHiVal;
    }

    public byte[] getLookup() {
        return this.indexLookup;
    }

    public float[] getMatrix() {
        return this.rgbMatrix;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getPDFColorSpace() {
        return this.colorSpace;
    }

    public PDFColorParams getParams() {
        PDFColorParams pDFColorParams = this;
        try {
            pDFColorParams = (PDFColorParams)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return pDFColorParams;
    }

    public Function getTintTransform() {
        return this.tintTransform;
    }

    public float[] getWhitePt() {
        return this.whitePt;
    }

    public void setAlphaMask(int[] nArray) {
        this.alphaMask = nArray;
    }

    public void setBaseModel(PDFColorModel pDFColorModel) {
        this.baseModel = pDFColorModel;
    }

    public void setBitsPerComponent(int n) {
        this.bitsPerComponent = n;
    }

    public void setBlackPt(float[] fArray) {
        this.blackPt = fArray;
    }

    public void setColorSpace(int n) {
        this.colorSpace = n;
    }

    public void setDecode(float[] fArray) {
        this.decode = fArray;
    }

    public void setGamma(float[] fArray) {
        this.gamma = fArray;
    }

    public void setIndexed(PDFColorModel pDFColorModel, int n, byte[] byArray) {
        if (pDFColorModel.getPDFColorSpace() != 20) {
            this.baseModel = pDFColorModel;
            this.lookupHiVal = n;
            this.indexLookup = byArray;
        }
    }

    public void setMatrix(float[] fArray) {
        this.rgbMatrix = fArray;
    }

    public void setNumComponents(int n) {
        this.numComponents = n;
    }

    public void setRange(float[] fArray) {
        this.decode = new float[fArray.length + 2];
        this.decode[0] = 0.0f;
        this.decode[1] = 100.0f;
        int n = fArray.length;
        while (n-- > 0) {
            this.decode[n + 2] = fArray[n];
        }
    }

    public void setTintTransform(Function function) {
        this.tintTransform = function;
    }

    public void setWhitePt(float[] fArray) {
        this.whitePt = fArray;
    }
}

