/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AWTOutlines;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.FontException;
import com.adobe.acrobat.sidecar.GlyphCache;
import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.sidecar.UnicodeTransliterater;
import com.adobe.acrobat.util.Log;
import com.adobe.util.WeakRef;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class FontADV {
    public String fName;
    public FontMetrics fm = null;
    public int fStyle;
    public Font lastFont;
    public int lastFontSize;
    public FontMetrics fontMetrics;
    AWTOutlines outlines;
    boolean fixedWidth;
    double widthStandard = -1.0;
    double italicAngle = 0.0;
    public AffineTransform fFontMatrix;
    private WeakRef glyphCacheRef = new WeakRef();
    public double xHeight = 1.0;
    public boolean isSmallCaps = false;
    public double[] bbox = null;
    int wMode = 0;
    Font base13Font = null;
    boolean isCIDFont = false;
    String cmap;
    int defUnitsPerEM = 1000;
    UnicodeTransliterater unicodeTransliterater;
    public static final int mode1Size = 4;
    public static final int mode1HxOffset = 0;
    public static final int mode1VxOffset = 1;
    public static final int mode1HPostionOffset = 2;
    public static final int mode1VPostionOffset = 3;
    FloatRect saveFloatBBox;

    public boolean alternateRender() throws Exception {
        return false;
    }

    public void checkForFixedWidth(double[] dArray) {
        if (dArray.length == 0) {
            return;
        }
        if (this.widthStandard == -1.0) {
            this.widthStandard = dArray[0];
        }
        if (this.fixedWidth) {
            int n = dArray.length;
            while (n-- > 0) {
                if (this.widthStandard == dArray[n]) continue;
                this.fixedWidth = false;
                break;
            }
        }
    }

    public int getAscent() {
        if (this.fm == null) {
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return this.fm.getAscent();
    }

    public AWTOutlines getAwtOutlines() {
        return this.outlines;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getBBox(double[] dArray) throws FontException {
        if (this.bbox != null) {
            dArray[0] = this.bbox[0];
            dArray[1] = this.bbox[1];
            dArray[2] = this.bbox[2];
            dArray[3] = this.bbox[3];
            return;
        }
        this.bbox = new double[4];
        if (this.outlines != null) {
            short[] sArray = new short[4];
            this.outlines.getBBox(sArray);
            this.saveFloatBBox = new FloatRect(sArray[0], sArray[1], sArray[2], sArray[3]);
            this.saveFloatBBox = this.saveFloatBBox.transformRect(this.fFontMatrix);
            double d = this.outlines.unitsPerEM();
            dArray[0] = this.bbox[0] = this.saveFloatBBox.getxMin() * d;
            dArray[1] = this.bbox[1] = this.saveFloatBBox.getyMin() * d;
            dArray[2] = this.bbox[2] = this.saveFloatBBox.getxMax() * d;
            dArray[3] = this.bbox[3] = this.saveFloatBBox.getyMax() * d;
            return;
        }
        Log.clog("Error FontADV without outlines");
        throw new FontException("Error:InternalFontError", this.fName);
    }

    public double getCapHeightScale() {
        return 1.0;
    }

    public int getDescent() {
        if (this.fm == null) {
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return this.fm.getDescent();
    }

    private Font getFont() {
        if (this.base13Font == null) {
            this.base13Font = new Font(this.fName, this.fStyle, 1000);
        }
        if (this.outlines != null) {
            Log.clog("called getFont on non-base13 font");
        }
        return this.base13Font;
    }

    public FloatRect getFontBBox() throws FontException {
        if (this.saveFloatBBox != null) {
            return this.saveFloatBBox;
        }
        this.bbox = new double[4];
        this.getBBox(this.bbox);
        this.saveFloatBBox = new FloatRect(this.bbox[0], this.bbox[1], this.bbox[2], this.bbox[3]);
        return this.saveFloatBBox;
    }

    public AffineTransform getFontMatrix() {
        return (AffineTransform)this.fFontMatrix.clone();
    }

    public SidecarImage getGlyph(int n, AffineTransform affineTransform, Rectangle rectangle, int n2, int n3) throws Exception {
        FontMetrics fontMetrics;
        Font font;
        SidecarImage sidecarImage = null;
        FloatPoint floatPoint = new FloatPoint(0.0, 1000.0);
        affineTransform.transformPoint(floatPoint, floatPoint);
        double d = Math.sqrt(floatPoint.x * floatPoint.x + floatPoint.y * floatPoint.y);
        int n4 = (int)d;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.lastFont == null || this.lastFontSize != n4) {
            font = new Font(this.fName, this.fStyle, n4);
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.setLastFont(font, fontMetrics, n4);
        } else {
            font = this.lastFont;
            fontMetrics = this.fontMetrics;
        }
        n5 = 0;
        n7 = -(this.getAscent() * n4 + 500) / 1000;
        n6 = fontMetrics.charWidth(n);
        n8 = (this.getDescent() * n4 + 500) / 1000;
        int n9 = (n5 - (n2 - 1)) / n2 * n2;
        int n10 = ((n6 += n2) + (n2 - 1)) / n2 * n2;
        int n11 = ((n7 -= n3) - (n3 - 1)) / n3 * n3;
        int n12 = (n8 + (n3 - 1)) / n3 * n3;
        int n13 = n9 / n2;
        int n14 = n11 / n3;
        int n15 = (n10 - n9) / n2;
        int n16 = (n12 - n11) / n3;
        rectangle.x = n13;
        rectangle.y = n14;
        rectangle.width = n15;
        rectangle.height = n16;
        int n17 = n15 * n2;
        int n18 = n16 * n3;
        if (n17 != 0 && n18 != 0) {
            Graphics graphics;
            block6: {
                sidecarImage = (SidecarImage)GraphicsUtils.createClipImage(n17 + n2, n18);
                graphics = sidecarImage.getGraphics();
                try {
                    graphics.setColor(Color.white);
                    if (this.outlines == null) {
                        char[] cArray = new char[]{(char)n};
                        graphics.setFont(font);
                        graphics.translate(-n9 + n2, -n11 + (n3 > 1 ? -1 : 0));
                        graphics.drawChars(cArray, 0, 1, 0, 0);
                        break block6;
                    }
                    graphics.translate(-n9 + n2, -n11 + (n3 > 1 ? -1 : 0));
                }
                catch (Throwable throwable) {
                    Object var29_29 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var29_28 = null;
            graphics.dispose();
        }
        return sidecarImage;
    }

    public GlyphCache getGlyphCache() {
        GlyphCache glyphCache = (GlyphCache)this.glyphCacheRef.get();
        if (glyphCache == null) {
            this.glyphCacheRef.unlock();
            glyphCache = new GlyphCache(this, this.fFontMatrix);
            this.glyphCacheRef.set(glyphCache);
        }
        return glyphCache;
    }

    public double getItalicAngle() {
        return this.italicAngle;
    }

    public boolean getSmallCaps() {
        return this.isSmallCaps;
    }

    public UnicodeTransliterater getUnicodeTransliterater() throws Exception {
        if (this.unicodeTransliterater != null) {
            return this.unicodeTransliterater;
        }
        if (this.isCIDFont) {
            if (this.outlines.isAdobeStandardOrdering(this.cmap)) {
                String string = AWTOutlines.getOrdering(this.cmap);
                if (string.equals("Japan1")) {
                    this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.Japan1, this.wMode == 0);
                    return this.unicodeTransliterater;
                }
                if (string.equals("Korea1")) {
                    this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.Korea1, this.wMode == 0);
                    return this.unicodeTransliterater;
                }
                if (string.equals("GB1")) {
                    this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.GB1, this.wMode == 0);
                    return this.unicodeTransliterater;
                }
                if (string.equals("CNS1")) {
                    this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.CNS1, this.wMode == 0);
                    return this.unicodeTransliterater;
                }
                this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.Identity, this.wMode == 0);
                return this.unicodeTransliterater;
            }
            this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.Identity, this.wMode == 0);
            return this.unicodeTransliterater;
        }
        this.unicodeTransliterater = new UnicodeTransliterater(UnicodeTransliterater.Identity, true);
        return this.unicodeTransliterater;
    }

    public int getwMode() {
        return this.wMode;
    }

    public double getxHeightScale() {
        return 1.0;
    }

    public boolean isCIDFont() {
        return this.isCIDFont;
    }

    public boolean isDirectDrawGlyph(int n) throws Exception {
        return true;
    }

    public void purge() {
        this.glyphCacheRef.set(null);
        this.glyphCacheRef.unlock();
        if (this.outlines != null) {
            this.outlines.purge();
        }
    }

    public void releaseGlyphCache() {
        this.glyphCacheRef.unlock();
    }

    public void renderAlternate(AWTGraphics aWTGraphics, ClipShape clipShape, int n) {
    }

    public void resetFixedWidth() {
        this.fixedWidth = true;
        this.widthStandard = -1.0;
    }

    public void setAwtFontProperties(String string, int n) {
        this.fStyle = n;
        this.fName = string;
    }

    public void setCMap(String string) {
        this.cmap = string;
    }

    public void setFontMatrix(AffineTransform affineTransform) {
        this.fFontMatrix = (AffineTransform)affineTransform.clone();
    }

    public void setIsCIDFont(boolean bl) {
        this.isCIDFont = bl;
    }

    public void setItalicAngle(double d) {
        this.italicAngle = d;
    }

    public void setLastFont(Font font, FontMetrics fontMetrics, int n) {
        this.lastFont = font;
        this.fontMetrics = fontMetrics;
        this.lastFontSize = n;
    }

    public void setOutlines(AWTOutlines aWTOutlines) {
        this.outlines = aWTOutlines;
        aWTOutlines.setSmallCapsFont(this.isSmallCaps);
        this.glyphCacheRef.set(null);
        this.glyphCacheRef.unlock();
    }

    public void setSmallCaps(double d) {
        this.xHeight = d;
        this.isSmallCaps = true;
        if (this.outlines != null) {
            this.outlines.setSmallCapsFont(true);
        }
    }

    public void setUnitsPerEM(int n) {
        this.defUnitsPerEM = n;
    }

    public void setwMode(int n) {
        this.wMode = n;
    }

    public int unitsPerEM() throws FontException {
        if (this.outlines != null) {
            return this.outlines.unitsPerEM();
        }
        return this.defUnitsPerEM;
    }
}

