/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.awt.Rectangle;

public class ShortBezierPath
implements Cloneable {
    public static final byte TYPE_MOVETO = 1;
    public static final byte TYPE_LINETO = 2;
    public static final byte TYPE_CURVETO_BEZ = 3;
    public static final byte TYPE_CLOSE = 4;
    public static final byte TYPE_CURVETO_QBEZ = 5;
    public static final byte TYPE_HIDDEN = -1;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_WIND = 1;
    public static final int FILL_STYLE_EO = 2;
    static final int SAMPLE_EQUAL_SPACING = 1;
    static final int SAMPLE_EQUAL_PARAM = 2;
    static final int SAMPLE_DERIVATIVE = 4;
    protected byte[] strip_type = null;
    protected short[] strip_x = null;
    protected short[] strip_y = null;
    protected short orgx;
    protected short orgy;
    int append_position;

    public ShortBezierPath(int n) {
        this.strip_x = MemUtil.allocShort(n);
        this.strip_y = MemUtil.allocShort(n);
        this.strip_type = MemUtil.allocByte(n);
        this.append_position = 0;
    }

    public ShortBezierPath(short[] sArray, short[] sArray2, byte[] byArray) {
        this.strip_x = sArray;
        this.strip_y = sArray2;
        this.strip_type = byArray;
        this.append_position = sArray.length;
    }

    public void addPoint(short s, short s2, byte by) {
        this.extend((short)(s + this.orgx), (short)(s2 + this.orgy), by);
    }

    public Object clone() {
        ShortBezierPath shortBezierPath = null;
        try {
            shortBezierPath = (ShortBezierPath)super.clone();
            if (this.strip_x != null) {
                shortBezierPath.strip_x = (short[])this.strip_x.clone();
            }
            if (this.strip_y != null) {
                shortBezierPath.strip_y = (short[])this.strip_y.clone();
            }
            if (this.strip_type != null) {
                shortBezierPath.strip_type = (byte[])this.strip_type.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return shortBezierPath;
    }

    public void closePath() {
        if (this.append_position > 0 && this.strip_type[this.append_position - 1] == 4) {
            return;
        }
        this.addPoint((short)0, (short)0, (byte)4);
    }

    public void curveTo(short s, short s2, short s3, short s4, short s5, short s6) {
        this.addPoint(s, s2, (byte)3);
        this.addPoint(s3, s4, (byte)3);
        this.addPoint(s5, s6, (byte)3);
    }

    public void curveToQ(short s, short s2, short s3, short s4) {
        this.addPoint(s, s2, (byte)5);
        this.addPoint(s3, s4, (byte)5);
    }

    public void curveToV(short s, short s2, short s3, short s4) {
        this.addPoint(this.strip_x[this.append_position - 1], this.strip_y[this.append_position - 1], (byte)3);
        this.addPoint(s, s2, (byte)3);
        this.addPoint(s3, s4, (byte)3);
    }

    public void dump() {
        Log.clog("Path has " + this.append_position + " (x,y) positions.");
        int n = 0;
        while (n < this.append_position) {
            Log.clogn("Point " + n + " : ");
            switch (this.strip_type[n]) {
                case 1: {
                    Log.clogn("TYPE_MOVETO");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 2: {
                    Log.clogn("TYPE_LINETO");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 3: {
                    Log.clogn("TYPE_CURVETO_BEZ");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 4: {
                    Log.clogn("TYPE_CLOSE");
                    break;
                }
                case 5: {
                    Log.clogn("TYPE_CURVETO_QBEZ");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
            }
            ++n;
        }
        Log.clog(" X componets ");
        int n2 = 0;
        while (n2 < this.append_position) {
            switch (this.strip_type[n2]) {
                case 1: {
                    Log.clog(Short.toString(this.strip_x[n2]));
                    break;
                }
                case 2: {
                    Log.clog(Short.toString(this.strip_x[n2]));
                    break;
                }
                case 3: {
                    Log.clog(Short.toString(this.strip_x[n2 += 2]));
                    break;
                }
                case 5: {
                    Log.clog(Short.toString(this.strip_x[++n2]));
                    break;
                }
            }
            ++n2;
        }
        Log.clog(" Y componets ");
        int n3 = 0;
        while (n3 < this.append_position) {
            switch (this.strip_type[n3]) {
                case 1: {
                    Log.clog(Short.toString(this.strip_y[n3]));
                    break;
                }
                case 2: {
                    Log.clog(Short.toString(this.strip_y[n3]));
                    break;
                }
                case 3: {
                    Log.clog(Short.toString(this.strip_y[n3 += 2]));
                    break;
                }
                case 5: {
                    Log.clog(Short.toString(this.strip_y[++n3]));
                    break;
                }
            }
            ++n3;
        }
    }

    protected void extend(int n) {
        int n2 = n == 0 ? this.strip_type.length + 10 : n;
        short[] sArray = MemUtil.allocShort(n2);
        short[] sArray2 = MemUtil.allocShort(n2);
        byte[] byArray = MemUtil.allocByte(n2);
        System.arraycopy(this.strip_x, 0, sArray, 0, this.append_position);
        System.arraycopy(this.strip_y, 0, sArray2, 0, this.append_position);
        System.arraycopy(this.strip_type, 0, byArray, 0, this.append_position);
        this.strip_x = sArray;
        this.strip_y = sArray2;
        this.strip_type = byArray;
    }

    protected void extend(short s, short s2, byte by) {
        if (this.append_position == this.strip_type.length - 1) {
            this.extend(0);
        }
        this.strip_x[this.append_position] = s;
        this.strip_y[this.append_position] = s2;
        this.strip_type[this.append_position] = by;
        ++this.append_position;
    }

    public Rectangle getBoundingBox() {
        short s = Short.MAX_VALUE;
        short s2 = Short.MIN_VALUE;
        short s3 = Short.MAX_VALUE;
        short s4 = Short.MIN_VALUE;
        int n = 0;
        while (n < this.append_position) {
            switch (this.strip_type[n]) {
                case 3: {
                    ++n;
                }
                case 5: {
                    ++n;
                }
                case 1: 
                case 2: {
                    if (this.strip_x[n] < s) {
                        s = this.strip_x[n];
                    }
                    if (this.strip_x[n] > s2) {
                        s2 = this.strip_x[n];
                    }
                    if (this.strip_y[n] < s3) {
                        s3 = this.strip_y[n];
                    }
                    if (this.strip_y[n] <= s4) break;
                    s4 = this.strip_y[n];
                    break;
                }
            }
            ++n;
        }
        return new Rectangle(s, s3, s2 - s, s4 - s3);
    }

    public short getxOrigin() {
        return this.orgx;
    }

    public short getyOrigin() {
        return this.orgy;
    }

    public void lineTo(short s, short s2) {
        this.addPoint(s, s2, (byte)2);
    }

    public BezierPath makeBezierPath() {
        BezierPath bezierPath = new BezierPath(this.append_position);
        int n = 0;
        while (n < this.append_position) {
            bezierPath.addPoint(this.strip_x[n], this.strip_y[n], this.strip_type[n]);
            ++n;
        }
        return bezierPath;
    }

    public void moveTo(short s, short s2) {
        this.addPoint(s, s2, (byte)1);
    }

    public int numPoints() {
        return this.append_position;
    }

    public void reset() {
        this.append_position = 0;
        this.orgx = 0;
        this.orgy = 0;
    }

    public void setOrigin(short s, short s2) {
        this.orgx = s;
        this.orgy = s2;
    }

    public ShortBezierPath transform(AffineTransform affineTransform) {
        ShortBezierPath shortBezierPath = (ShortBezierPath)this.clone();
        int n = (int)(affineTransform.geta() * 65536.0);
        int n2 = (int)(affineTransform.getb() * 65536.0);
        int n3 = (int)(affineTransform.getc() * 65536.0);
        int n4 = (int)(affineTransform.getd() * 65536.0);
        int n5 = (int)(affineTransform.getx() + 0.5);
        int n6 = (int)(affineTransform.gety() + 0.5);
        int n7 = 0;
        while (n7 < this.append_position) {
            short s = this.strip_x[n7];
            short s2 = this.strip_y[n7];
            shortBezierPath.strip_x[n7] = (short)((n * s >> 16) + (n3 * s2 >> 16) + n5);
            shortBezierPath.strip_y[n7] = (short)((n2 * s >> 16) + (n4 * s2 >> 16) + n6);
            ++n7;
        }
        return shortBezierPath;
    }
}

