/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Log {
    private static PrintWriter logFile;
    protected static boolean verboseLogging;
    protected static boolean debugLogging;
    private static boolean consoleLogging;
    private static Frame console;
    private static TextArea consoleText;

    static {
        verboseLogging = false;
        debugLogging = false;
        consoleLogging = false;
    }

    public static void clog() {
        Log.clogn("\n");
    }

    public static void clog(String string) {
        Log.clogn(String.valueOf(string) + "\n");
    }

    public static void clogn(String string) {
        if (verboseLogging) {
            Log.logn(string);
        }
    }

    public static void closeLog() {
        if (logFile != null) {
            logFile.close();
        }
    }

    public static void log(String string) {
        Log.logn(String.valueOf(string) + "\n");
    }

    public static void logStackTrace(Throwable throwable) {
        if (throwable != null) {
            if (consoleLogging) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                Log.logn(((Object)byteArrayOutputStream).toString());
            } else if (verboseLogging || debugLogging) {
                if (logFile == null) {
                    logFile = new PrintWriter(System.out, true);
                }
                throwable.printStackTrace(logFile);
                logFile.flush();
            }
        }
    }

    public static void logn(String string) {
        if (consoleLogging) {
            consoleText.append(string);
        } else if (verboseLogging || debugLogging) {
            if (logFile == null) {
                logFile = new PrintWriter(System.out, true);
            }
            logFile.print(string);
            logFile.flush();
        }
    }

    public static void openLog(String string) throws Exception {
        logFile = string != null ? new PrintWriter(new FileOutputStream(string), true) : new PrintWriter(System.out, true);
    }

    public static void setConsole(boolean bl) {
        consoleLogging = bl;
        if (consoleLogging) {
            console = new Frame("Debug Console");
            console.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    console.dispose();
                }
            });
            ((Component)console).setBackground(Color.white);
            console.setLayout(new BorderLayout());
            consoleText = new TextArea(5, 20);
            console.add((Component)consoleText, "Center");
            ((Component)console).setSize(100, 100);
            console.show();
        }
    }

    public static void setDebugLogging(boolean bl) {
        debugLogging = bl;
    }

    public static void setVerboseLogging(boolean bl) {
        verboseLogging = bl;
    }
}

