/* MessageDialog.java
 *
 * created: Mon Dec 14 1998
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/MessageDialog.java,v 1.10 2000/01/24 17:04:20 kmr Exp $
 **/

package diana.components;

import java.awt.*;
import java.awt.event.*;

/**
 *  A popup dialog box that displays a message and has an OK Button.
 *
 *  @author Kim Rutherford
 *  @version $Id: MessageDialog.java,v 1.10 2000/01/24 17:04:20 kmr Exp $
 **/

public class MessageDialog extends Dialog {
  /**
   *  Create a blocking MessageDialog component.
   *  @param parent The parent window.
   *  @param message The message to display in the Dialog and to use as the
   *    frame title.
   **/
  public MessageDialog (final Frame parent, final String message) {
    this (parent, message, message, true);
  }
  
  /**
   *  Create a new MessageDialog component.
   *  @param parent The parent window.
   *  @param message The message to display in the Dialog and to use as the
   *    frame title.
   *  @param modal If true, dialog blocks input to the parent window when
   *    shown.
   **/
  public MessageDialog (final Frame parent, final String message,
                        final boolean modal) {
    this (parent, message, message, modal);
  }
  
  /**
   *  Create a blocking MessageDialog component.
   *  @param parent_frame The parent window.
   *  @param title The title of the new dialog Frame.
   *  @param message The message to display in the Dialog.
   **/
  public MessageDialog (final Frame parent_frame,
                        final String title,
                        final String message) {
    this (parent_frame, title, message, true);
  }

  /**
   *  Create a new MessageDialog component.
   *  @param parent_frame The parent window.
   *  @param title The title of the new dialog Frame.
   *  @param message The message to display in the Dialog.
   *  @param modal If true, dialog blocks input to the parent window when
   *    shown.
   **/
  public MessageDialog (final Frame parent_frame,
                        final String title,
                        final String message,
                        final boolean modal) {
    super (parent_frame, title, modal);
    
    add (new Label (message), "North");

    final Panel panel = new Panel ();

    panel.add (ok_button);
    ok_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        MessageDialog.this.dispose ();
      }
    });

    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent event) {
        MessageDialog.this.dispose ();
      }
    });

    addKeyListener (new KeyAdapter () {
      public void keyTyped(final KeyEvent e) {
//    System.out.println ("key:" + e.getKeyChar () + "  " + e.getKeyCode ());
        MessageDialog.this.dispose ();
      }
    });
    
    add (panel, "South");
    pack ();
    
    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));

    setVisible (true);
  }

  final Button ok_button = new Button ("OK");
}

