#!/usr/local/bin/python
#
# adzapper
# Copyright 1999 - 2001 Adam Feuer
# Adam Feuer <adamf@pobox.com>
#
# This file is part of adzapper.
#
# adzapper is free software; you can redistribute it and/or modify
# it under the terms of the Python License, as published by the
# Python Software Foundation.
#
# adzapper is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# Python License for more details.
#
# You should have received a copy of the Python License along
# with adzapper; see the file COPYING.
#
#
# this provides a method used to override the http_server.writable method--
# removes a circular reference problem
#
RCS_ID =  '$Id: http_server_fixes.py,v 1.4 2001/09/02 04:47:16 adamf Exp $'

#
# this is to fix http_channel;
# when using rushing's proxy scheme, there is a circular reference.
#
def writable (self):
    if not hasattr(self,'writable_for_proxy'):
	# this is just the normal async_chat 'writable', here for comparison
	return self.ac_out_buffer or len(self.producer_fifo)
    else:
	# this version of writable supports the idea of a 'stalled' producer
	# [i.e., it's not ready to produce any output yet] This is needed by
	# the proxy, which will be waiting for the magic combination of
	# 1) hostname resolved
	# 2) connection made
	# 3) data available.
	if self.ac_out_buffer:
	    return 1
	elif len(self.producer_fifo):
	    p = self.producer_fifo.first()
	    if hasattr (p, 'stalled'):
		return not p.stalled()
	    else:
		return 1

# this is to fix http_channel;
# we need to mark the channel as closed when socket is closed
# (this will happen when user hits the 'stop' button on their browser)
# this way we can avoid exceptions trying to write to a closed socket
# (suggested by Alexey Marinichev <lyosha@lyosha.transas.com> )
def handle_close(self):
    self.shut = 1
    self.close()


# this is to stop the server from logging
def log(self,bytes):
    pass
