# -*- Mode: Python; tab-width: 4 -*-

def poll (timeout=0.0):
	if socket_map:
		sockets = socket_map.keys()
		
		r = filter (lambda x: x.readable(), sockets)
		w = filter (lambda x: x.writable(), sockets)
		e = []

		r_reverse_map = {}
		w_reverse_map = {}
		
		r = map (lambda x: (x.fileno(), x), r)
		w = map (lambda x: (x.fileno(), x), w)
		
		for fd, o in r:
			r_reverse_map[fd] = o
		for fd, o in w:
			w_reverse_map[fd] = o

		r = map (lambda x: x[0], r)
		w = map (lambda x: x[0], w)

		(r,w,e) = select.select (r,w,e, timeout)

		r = map (lambda x,rm=r_reverse_map: rm[x], r)
		w = map (lambda x,rm=w_reverse_map: rm[x], w)

		del r_reverse_map, w_reverse_map

		for x in r:
			try:
				x.handle_read_event()
			except:
				x.handle_error (sys.exc_type, sys.exc_value, sys.exc_traceback)
		for x in w:
			try:
				x.handle_write_event()
			except:
				x.handle_error (sys.exc_type, sys.exc_value, sys.exc_traceback)

def poll (timeout=0.0):
	if socket_map:
		sockets = socket_map.keys()
		r = filter (lambda x: x.readable(), sockets)
		w = filter (lambda x: x.writable(), sockets)
		e = []

		(r,w,e) = select.select (r,w,e, timeout)

		for x in r:
			try:
				x.handle_read_event()
			except:
				try:
					ei = sys.exc_info()
					apply (x.handle_error, ei)
				finally:
					del ei
		for x in w:
			try:
				x.handle_write_event()
			except:
				try:
					ei = sys.exc_info()
					apply (x.handle_error, ei)
				finally:
					del ei
