#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#

# zaplet classes
# for use with adzapper filtering proxy

RCS_ID =  '$Id: __init__.py,v 1.2 2001/09/02 04:47:17 adamf Exp $'

# standard modules
import re

# adzapper modules
from debug import debug

XML_PARSER = "xml.sax.drivers.drv_xmlproc"
XMLDOC = '<?xml version="1.0"?>\n'

BLOCK_POPUPS_REGEX = "window\.open\s*(\(.*\n*.*\))+"

numeric_host = re.compile ('[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')
numeric_network = re.compile ('[0-9]+\.([0-9]+\.)?([0-9]+\.)?([[0-9]+\*])?')


def normalize_whitespace(text):
    "Remove redundant whitespace from a string"
    return string.join( string.split(text), ' ')

