// argcb.h
// Handle the SIGUSR1 signal as a "new arguments" signal.
//
// Copyright (C) 2000 Agenda Computing Inc.
// Copyright (C) 2000 Bradley D. LaRonde <brad@ltc.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef __REARG_H
#define __REARG_H

#include <sys/types.h>

typedef void (*arg_callback_t)(int, char**, void* data);

void rearg_callback(const char* id, arg_callback_t cb, void* data);
int execsv(const char* path, char* const argv[]);
int rearg_pid(const pid_t pid, char* const argv[]);
int rearg_name(const char* name, char* const argv[]);
int rearg(char* const argv[]);

int execsv(const char* path, char* const argv[]);

#endif
