#ifndef VR_RECORD_ID_H
#define VR_RECORD_ID_H

#include <time.h>
#include <db1/db.h>

// For the time being the parameter dbp doesn't matter, but
// we suggest passing your DB* dbp you opened for writing.
long get_new_id(DB* dbp) {
	long ret = (long)time(NULL);
	// reserve [-1, -10] as special use
	if((ret < 0) && (ret > -10))
		ret += 100;

	// Check that the id doesn't exist
	DBT key, content;
	key.data = &ret;
	key.size = 4;
	content.data = 0;
	content.size = 0;
	while (dbp->get(dbp, &key, &content, 0)==0) ++ret;
	return ret;
}
#endif
