/* Copyright (C) 1995, 1996 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#ifndef _SYS_CACHECTL_H
#define _SYS_CACHECTL_H 1

#include <features.h>

/*
 * Get the kernel definition for the op bits.
 */
#include <asm/cachectl.h>

__BEGIN_DECLS

#ifdef __USE_MISC
extern int cachectl __P ((void *addr, __const int nbytes, __const int op));
#endif
extern int __cachectl __P ((void *addr, __const int nbytes, __const int op));
#ifdef __USE_MISC
extern int cacheflush __P ((void *addr, __const int nbytes, __const int op));
#endif
extern int _flush_cache __P ((char *addr, __const int nbytes, __const int op));

__END_DECLS

#endif /* _SYS_CACHECTL_H */
