// Fl_Indexed_Browser.H
// a virtual subclass from Fl_Browser_
//
// Copyright (C) 2000 Softfield Research Ltd.

#ifndef FL_INDEXED_BROWSER_H
#define FL_INDEXED_BROWSER_H

#include <FL/Fl_Browser_.H>
#include <FL/fl_draw.H>

static const int no_columns[2] = {-1, 0};
const int DISABLED_COLUMN_WIDTH = -999;

class Fl_Indexed_Browser : public Fl_Browser_ {
	int list_size_;
	int selected_row_;
	const int* column_widths_;

	// internally void* pointer working from 1 till list_size_.
	//external item id starts from 1 till list_size_ . 0 stands for error

	void *item_first() const { return list_size_ ? (void*)1 : (void*)0; }

	void *item_next(void *v) const;
	void *item_prev(void *v) const;

	int item_height(void *v) const { return v ? height_item((int)v) : 0; }

	int item_width(void *) const;

        // you may override this this function.
	virtual int height_item(int) const { return textsize() + 2; }

	// you shall always override either this function or draw_row(int, int, int, int, int).
	virtual void draw_cells(int r, int c, int x, int y, int w, int h) const;
	virtual void draw_row(int row, int x, int y, int w, int h) const;

	void item_draw(void* v, int x, int y, int w, int h) const
               { draw_row((int)v, x, y, w, h); }

protected:

	void item_select(void* l, int v = 1)
               { selected_row_ = v ? (int)l : 0; }

	int item_selected(void* l) const
	      { return (l && selected_row_ == (int)l); }

	int column_width_cal(int col) const;

public:
	Fl_Indexed_Browser(int x, int y, int w, int h, const char *l = 0);

        void column_widths(const int* nw) { column_widths_ = nw; }
	const int* colum_widths() { return column_widths_; }

	void update_list(int lsize);

	int value() { return (int)selection(); }

	int col(int xv);

	// row is start from 1 till available in list.
	void get_cell_bounds(int& x, int& y, int& w, int& h, int row, int col);

	int size() { return list_size_; }
	
	int displayed(int i);
};

#endif
