#ifndef __FL_PAGED_SCROLL_H
#define __FL_PAGED_SCROLL_H

#include <FL/Fl_Scroll.H>
#include <flpda/Fl_Page_UpDown_Button.H>

class Fl_Paged_Scroll : public Fl_Scroll {
	private:
		Fl_Page_UpDown_Button* page_button;
		bool auto_adjust_;
		
		void update_page_button();
		int content_height();

		void adjust_down();
		void adjust_up();
		
	protected:
		int handle(int event);
		
	public:
		Fl_Paged_Scroll(int x, int y, int w, int h, char* l = 0, Fl_Page_UpDown_Button* p = 0);

		void page_updown_button(Fl_Page_UpDown_Button* p);
		void draw();
		void resize(int x, int y, int w, int h);
		
		void auto_adjust();
		void no_auto_adjust();
};

#endif
