// WidgetFactory.h
// The generic widget generator
//
// Copyright (C) 2000 Bradley D. LaRonde <brad@ltc.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef WIDGET_FACTORY_H
#define WIDGET_FACTORY_H


// for stock FLTK, comment this out
// #define FLTK_VR3


//#define VR_BUTTON_UP_BOX FL_BORDER_BOX
#define VR_BUTTON_UP_BOX FL_ROUNDED_BOX
//#define VR_BUTTON_DOWN_BOX FL_BORDER_BOX
#define VR_BUTTON_DOWN_BOX FL_ROUNDED_BOX
#define VR_INPUT_BOX FL_BORDER_BOX
#define VR_PAGEKEY_BOX FL_FLAT_BOX
#define VR_BROWSER_BOX FL_FLAT_BOX
#define VR_MENU_BOX FL_BORDER_BOX


#include <FL/Fl.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Pack.H>
#include <FL/Fl_Select_Browser.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Repeat_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Choice.H>
#include <flpda/Fl_Page_UpDown_Button.H>

#include <Flek/Fl_App_Window.H>
#include <Flek/Fl_Dockable_Window.H>

#include <flpda/Fl_Paged_Select_Browser.H>
#include <flpda/Fl_Paged_Hold_Browser.H>

// Provide backwards compatability.
class Widget_Factory;
typedef Widget_Factory WidgetFactory;

class Widget_Factory {
private:
	// Top-level window size
	static int w() { return 160; }
	static int h() { return 220; }

	static const Fl_Font base_font = FL_HELVETICA;

	enum {
		base_fontsize = 10,
		base_height = 16,
		button_width = 32,
		input_width = 100,
                pagekey_width = 8
	};

public:
	// Discrete characteristics
	// Please use the factory methods instead of these if possible.
	static Fl_Font textfont() { return base_font; }
	static int textsize() { return base_fontsize; }
	static int labelsize() { return base_fontsize; }
	static int buttonheight() { return base_height; }
	static int buttonwidth() { return button_width; }
        static int pagekeywidth() { return pagekey_width; }
	static int inputwidth() { return input_width; }

	// Factory methods.

	static Fl_App_Window* new_window(const char* label = 0) {
#ifdef FLTK_VR3
                Fl::set_color(FL_SELECTION_COLOR, 0, 0, 0); // change selection color to black
#endif
                Fl_App_Window* window = new Fl_App_Window(w(), h(), label);
		window->color(FL_WHITE);
		window->resizable(window);
		return window;
	}

	static Fl_Dockable_Window* new_toolbar(const char* label = 0) {
		Fl_Dockable_Window* g = new Fl_Dockable_Window(w(), base_height, label);
		// Don't show a gripper on the toolbar.
		g->grippertype(0);
		Fl_Pack* p = new Fl_Pack(0, 0, w(), base_height, 0);
 		p->type(Fl_Pack::HORIZONTAL);
		return g;
	}

	static Fl_Select_Browser* new_select_browser(int x, int y,
		int w, int h, const char* label = 0) {
		Fl_Select_Browser* b = new Fl_Select_Browser(x, y, w, h, label);
#ifdef FLTK_VR3
		b->box(VR_BROWSER_BOX);
#else
		b->box(FL_FLAT_BOX);
#endif
                b->textsize(textsize());
		b->has_scrollbar(0);
		return b;
	}

	static Fl_Input* new_input(int x, int y,
		int w = input_width, int h = base_height, const char* label = 0) {
		Fl_Input* i = new Fl_Input(x, y, w, h, label);
		i->labelsize(textsize());
		i->textsize(textsize());
#ifdef FLTK_VR3
                i->box(VR_INPUT_BOX);
#endif
		return i;
	}

	static Fl_Button* new_button(int x, int y,
		const char* label = 0, Fl_Callback* callback = 0, void* data = 0) {
		Fl_Button* b = new Fl_Button(x, y,
			 button_width, base_height, label);
		b->labelsize(labelsize());
		if(callback != 0)
			b->callback(callback, data);
#ifdef FLTK_VR3
                b->box(VR_BUTTON_UP_BOX);
                b->down_box(VR_BUTTON_DOWN_BOX);
                b->selection_color(FL_BLACK);
#endif
		return b;
	}

	static Fl_Button* new_button(const char* label = 0,
		Fl_Callback* callback = 0, void* data = 0) {
		return new_button(0, 0, label, callback, data);
	}

	static Fl_Repeat_Button* new_repeat_button(int x, int y,
		const char* label = 0, Fl_Callback* callback = 0, void* data = 0) {
		Fl_Repeat_Button* b = new Fl_Repeat_Button(x, y,
			 button_width, base_height, label);
		b->labelsize(labelsize());
		if(callback != 0)
			b->callback(callback, data);
#ifdef FLTK_VR3
                b->box(VR_BUTTON_UP_BOX);
                b->down_box(VR_BUTTON_DOWN_BOX);
                b->selection_color(FL_BLACK);
#endif
		return b;
	}

	static Fl_Repeat_Button* new_repeat_button(const char* label = 0,
		Fl_Callback* callback = 0, void* data = 0) {
		return new_repeat_button(0, 0, label, callback, data);
	}

	static Fl_Menu_Button* new_menu_button(int x, int y,
		const char* label = 0, Fl_Callback* callback = 0, void* data = 0) {
		Fl_Menu_Button* b = new Fl_Menu_Button(x, y,
			button_width, base_height, label);
		b->labelsize(labelsize());
		b->textsize(labelsize());
		if(callback != 0)
			b->callback(callback, data);
#ifdef FLTK_VR3
                b->box(VR_BUTTON_UP_BOX);
                b->down_box(VR_BUTTON_DOWN_BOX);
                b->menu_box(VR_MENU_BOX);
                b->selection_color(FL_BLACK);
#endif
		return b;
	}

	static Fl_Menu_Button* new_menu_button(const char* label = 0,
		Fl_Callback* callback = 0, void* data = 0) {
		return new_menu_button(0, 0, label, callback, data);
	}

	static Fl_Choice* new_choice(int x, int y,
		const char* label = 0, Fl_Callback* callback = 0, void* data = 0) {
		Fl_Choice* b = new Fl_Choice(x, y,
			input_width, base_height, label);
		b->labelsize(labelsize());
		b->textsize(labelsize());
		if(callback != 0)
			b->callback(callback, data);
#ifdef FLTK_VR3
                b->box(VR_BUTTON_UP_BOX);
                b->down_box(VR_BUTTON_DOWN_BOX);
                b->menu_box(VR_MENU_BOX);
//                b->selection_color(FL_BLACK);
#endif
		return b;
	}

	static Fl_Choice* new_choice(const char* label = 0,
		Fl_Callback* callback = 0, void* data = 0) {
		return new_choice(0, 0, label, callback, data);
	}

        static Fl_Page_UpDown_Button* new_pagekey(int x, int y) {
                Fl_Page_UpDown_Button* b =
                  new Fl_Page_UpDown_Button(x, y, pagekey_width, base_height);
#ifdef FLTK_VR3
                b->box(VR_BUTTON_UP_BOX); // doesn't really do anything
#endif
		return b;
	}

	static Fl_Page_UpDown_Button* new_pagekey() {
		return new_pagekey(0, 0);
	}

	static Fl_Paged_Select_Browser* new_paged_select_browser(int x, int y,
		int w, int h, Fl_Page_UpDown_Button* p = 0) {
		Fl_Paged_Select_Browser* b = new Fl_Paged_Select_Browser(x, y, w, h, p);
#ifdef FLTK_VR3
		b->box(VR_BROWSER_BOX);
#else
		b->box(FL_FLAT_BOX);
#endif
		b->textsize(textsize());
		b->has_scrollbar(0);
		return b;
	}

	static Fl_Paged_Hold_Browser* new_paged_hold_browser(int x, int y,
		int w, int h, Fl_Page_UpDown_Button* p = 0) {
		Fl_Paged_Hold_Browser* b = new Fl_Paged_Hold_Browser(x, y, w, h, p);
#ifdef FLTK_VR3
		b->box(VR_BROWSER_BOX);
#else
		b->box(FL_FLAT_BOX);
#endif
                b->textsize(textsize());
		b->has_scrollbar(0);
		return b;
	}
};

#endif
