#ifndef __PLUGINS_H
#define __PLUGINS_H

#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>

#include <FL/Fl.H>
#include <FL/Fl_Widget.H>
#include <FL/Fl_Menu_.H>

typedef void (*plugins_cb_func)(char* plugin_name, char* plugin_label, FILE* fp, void* data);
typedef bool (*plugins_init_cb_func)(char* plugin_name, void* data);

/*
extern plugins_cb_func plugins_user_cb;
extern plugins_init_cb_func plugins_init_user_cb;
extern void* plugins_user_data;
extern void* plugins_init_user_data;
extern char plugins_path[1024];

extern char plugins_export_type[1024];
extern char plugins_export_filename[1024];
*/

/* Set the callback func when a plugin is exec. */
void plugins_callback(plugins_cb_func func, void* data);

/* Set the default content type for the plugin to use */
void plugins_type(char* type);

/* Set the directory that contains all the plugins */
void plugins_dir(char* path);

/* Set the default filename for the plugin to use */
void plugins_filename(char* filename);

/* Add plugin selection to the fltk menu_ */
void add_plugins_menu(Fl_Menu_* menu);
int add_plugin_to_menu(Fl_Menu_* menu, char* label, char* plugin_name);

/* Use the following in the init_cb function to dynamically set 
the content type and filename before running a plugin */
void set_type(char* type);
void set_filename(char* filename);

#endif
