// vr_categories.h
//
// Copyright (C) 2000 Agenda Computing Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef VR_CATEGORIES_H
#define VR_CATEGORIES_H

#include <vector>
#include <string>
#include <cstdio>

class VR_Category
{
	bool _modified;
	bool _deleted;
	unsigned char _category;
	std::string _name;

	enum {Modified = 1, Deleted = 2};
public:
	VR_Category();
	void load(std::string d);
	std::string save();
	bool deleted() { return _deleted; }
	void deleted(bool d) { _deleted = d; }
	bool modified() {return _modified;}
	void modified(bool b) { _modified = b;}
	unsigned char category() { return _category; }
	void category(unsigned char cat) { _category = cat; }
	std::string category_name() { return _name; }
	void category_name(std::string n) { _name = n; }
};

class VR_Categories
{
	std::vector<VR_Category> categories;

public:
	void load(std::string d);
	std::string save();
	std::vector<VR_Category> data() { return categories;};
	void data(std::vector<VR_Category> list) { categories = list; };
};
#endif
