/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportIPConfigPanel;
import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportInfoTextField;
import airport.AirportPPPoEConfigPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;

public class AirportEthernetConfigPanel
extends AirportInfoPanel
implements ItemListener {
    private AirportInfoRadioButton dhcpConfigButton = new AirportInfoRadioButton("DHCP configuration of base station");
    private AirportInfoRadioButton manualConfigButton;
    private AirportInfoRadioButton pppoeButton;
    private AirportInfoPanel manualIPConfigPanel;
    private AirportInfoPanel ethernetButtonPanel;
    private AirportInfoPanel dhcpIPConfigPanel;
    private AirportInfoPanel dhcpClientIDPanel;
    private AirportInfoPanel pppoeClientIDPanel;
    private AirportInfoTextField dhcpClientIDField;
    private ButtonGroup dhcpManualButtonGroup;

    public AirportEthernetConfigPanel(AirportInfo theInfo) {
        this.dhcpConfigButton.addInfoRecord(theInfo.get("waCV"), "00000300");
        this.manualConfigButton = new AirportInfoRadioButton("Manual configuration of base station");
        this.manualConfigButton.addInfoRecord(theInfo.get("waCV"), "00000400");
        this.pppoeButton = new AirportInfoRadioButton("PPPoE configuration of base station");
        this.pppoeButton.addInfoRecord(theInfo.get("waCV"), "00000900");
        this.dhcpManualButtonGroup = new ButtonGroup();
        this.dhcpManualButtonGroup.add(this.dhcpConfigButton);
        this.dhcpManualButtonGroup.add(this.manualConfigButton);
        this.dhcpManualButtonGroup.add(this.pppoeButton);
        this.manualIPConfigPanel = new AirportIPConfigPanel(theInfo);
        this.dhcpClientIDField = new AirportInfoTextField(theInfo.get("waDC"), 20);
        this.pppoeClientIDPanel = new AirportPPPoEConfigPanel(theInfo);
        this.dhcpIPConfigPanel = new AirportIPConfigPanel(theInfo, "", "", "");
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.dhcpClientIDPanel = new AirportInfoPanel();
        this.dhcpClientIDPanel.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        JLabel theLabel = new JLabel("DHCP client ID");
        theLayout.setConstraints(theLabel, c);
        this.dhcpClientIDPanel.add(theLabel);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        theLayout.setConstraints(this.dhcpClientIDField, c);
        this.dhcpClientIDPanel.add(this.dhcpClientIDField);
        this.ethernetButtonPanel = new AirportInfoPanel();
        this.ethernetButtonPanel.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.dhcpConfigButton, c);
        this.ethernetButtonPanel.add(this.dhcpConfigButton);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.manualConfigButton, c);
        this.ethernetButtonPanel.add(this.manualConfigButton);
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.pppoeButton, c);
        this.ethernetButtonPanel.add(this.pppoeButton);
        this.setLayout(theLayout);
        c.anchor = 10;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.ethernetButtonPanel, c);
        this.add(this.ethernetButtonPanel);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.manualIPConfigPanel, c);
        this.add(this.manualIPConfigPanel);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.dhcpClientIDPanel, c);
        this.add(this.dhcpClientIDPanel);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.pppoeClientIDPanel, c);
        this.add(this.pppoeClientIDPanel);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.dhcpIPConfigPanel, c);
        this.add(this.dhcpIPConfigPanel);
        this.dhcpIPConfigPanel.setVisible(false);
        this.manualConfigButton.addItemListener(this.manualIPConfigPanel);
        this.manualConfigButton.addItemListener(this);
        this.manualIPConfigPanel.setEnabled(this.manualConfigButton.isSelected());
        this.manualIPConfigPanel.setVisible(this.manualConfigButton.isSelected());
        this.dhcpConfigButton.addItemListener(this.dhcpIPConfigPanel);
        this.pppoeButton.addItemListener(this.dhcpIPConfigPanel);
        this.dhcpIPConfigPanel.setEnabled(this.dhcpConfigButton.isSelected() || this.pppoeButton.isSelected());
        this.dhcpConfigButton.addItemListener(this.dhcpClientIDPanel);
        this.dhcpConfigButton.addItemListener(this);
        this.dhcpClientIDPanel.setEnabled(this.dhcpConfigButton.isSelected());
        this.dhcpClientIDPanel.setVisible(this.dhcpConfigButton.isSelected());
        this.pppoeButton.addItemListener(this.pppoeClientIDPanel);
        this.pppoeButton.addItemListener(this);
        this.pppoeClientIDPanel.setEnabled(this.pppoeButton.isSelected());
        this.pppoeClientIDPanel.setVisible(this.pppoeButton.isSelected());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.manualIPConfigPanel.setEnabled(enabled && this.manualConfigButton.isSelected());
        this.dhcpIPConfigPanel.setEnabled(enabled && (this.dhcpConfigButton.isSelected() || this.pppoeButton.isSelected()));
        this.dhcpClientIDPanel.setEnabled(enabled && this.dhcpConfigButton.isSelected());
        this.pppoeClientIDPanel.setEnabled(enabled && this.pppoeButton.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        this.manualIPConfigPanel.setVisible(this.manualConfigButton.isSelected());
        this.dhcpClientIDPanel.setVisible(this.dhcpConfigButton.isSelected());
        this.pppoeClientIDPanel.setVisible(this.pppoeButton.isSelected());
    }
}

