/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class AirportInfoComboBox
extends AirportInfoPanel
implements AirportInfoComponent {
    private AirportInfoRecord theRecord;
    private JComboBox comboBox;

    public AirportInfoComboBox(String label, AirportInfoRecord theRecord) {
        JLabel theLabel = new JLabel(label);
        this.comboBox = new JComboBox();
        this.add("West", theLabel);
        this.add("East", this.comboBox);
        this.theRecord = theRecord;
    }

    public void addItemAndValue(String itemLabel, String valueString) {
        Association newItem = new Association(itemLabel, valueString);
        this.comboBox.addItem(newItem);
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        String currentValue = this.theRecord.toString();
        int i = 0;
        while (i < this.comboBox.getItemCount()) {
            Association nextItem = (Association)this.comboBox.getItemAt(i);
            if (nextItem.valueString.equalsIgnoreCase(currentValue)) {
                this.comboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public void writeValue() throws ValueFormatException {
        Association theItem = (Association)this.comboBox.getSelectedItem();
        this.theRecord.setBytesFromString(theItem.valueString);
    }

    private class Association {
        String itemLabel;
        String valueString;

        public Association(String itemLabel, String valueString) {
            this.itemLabel = itemLabel;
            this.valueString = valueString;
        }

        public String toString() {
            return this.itemLabel;
        }
    }
}

