/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportAccessControlTable;
import airport.AirportAdvancedPanel;
import airport.AirportBridgingPanel;
import airport.AirportDHCPPanel;
import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportMainPanel;
import airport.AirportNetworkPanel;
import airport.AirportPortMappingPanel;
import airport.AirportWirelessPanel;
import airport.ValueFormatException;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class AirportInfoTabbedPane
extends JTabbedPane {
    public AirportInfoTabbedPane(AirportInfo airportInfo) {
        this.setUpDisplay(airportInfo);
    }

    private void setUpDisplay(AirportInfo airportInfo) {
        AirportMainPanel mainPanel = new AirportMainPanel(airportInfo);
        AirportWirelessPanel wirelessPanel = new AirportWirelessPanel(airportInfo);
        AirportNetworkPanel connectionPanel = new AirportNetworkPanel(airportInfo);
        AirportBridgingPanel bridgingPanel = new AirportBridgingPanel(airportInfo);
        AirportDHCPPanel dhcpPanel = new AirportDHCPPanel(airportInfo);
        AirportAccessControlTable accessTablePanel = new AirportAccessControlTable(airportInfo);
        AirportPortMappingPanel portMapTablePanel = new AirportPortMappingPanel(airportInfo);
        AirportAdvancedPanel advancedPanel = new AirportAdvancedPanel(airportInfo);
        this.addTab("Main", mainPanel);
        this.addTab("Wireless LAN Settings", wirelessPanel);
        this.addTab("Network Connection", connectionPanel);
        this.addTab("Bridging Functions", bridgingPanel);
        this.addTab("DHCP Functions", dhcpPanel);
        this.addTab("Access Control", accessTablePanel);
        this.addTab("Port Mappings", portMapTablePanel);
        this.addTab("Advanced Settings", advancedPanel);
    }

    public void writeData() throws ValueFormatException {
        int numTabs = this.getTabCount();
        int i = 0;
        while (i < numTabs) {
            Component nextPanel = this.getComponentAt(i);
            if (nextPanel instanceof AirportInfoPanel) {
                try {
                    ((AirportInfoPanel)nextPanel).writeValue();
                }
                catch (ValueFormatException e) {
                    this.setSelectedIndex(i);
                    throw e;
                }
            }
            ++i;
        }
    }
}

