/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoLabelledScaledValueField;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportPPPoELoginInfoDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;

public class AirportPPPoEConfigPanel
extends AirportInfoPanel
implements ActionListener {
    private JButton loginButton;
    private ButtonGroup connectionGroup;
    private AirportInfoRadioButton pppoeAlwaysStayConnectedButton;
    private AirportInfoRadioButton pppoeAutomaticConnectButton;
    private AirportInfoRadioButton pppoeManualConnectButton;
    private AirportInfoLabelledScaledValueField pppoeDisconnectTimeoutField;
    private AirportInfo theInfo;
    private AirportInfoPanel pppoeDisconnectTimeoutPanel;

    public AirportPPPoEConfigPanel(AirportInfo theInfo) {
        this.theInfo = theInfo;
        this.pppoeAlwaysStayConnectedButton = new AirportInfoRadioButton("Always stay connected");
        this.pppoeAlwaysStayConnectedButton.addInfoRecord(theInfo.get("peSC"), "01");
        this.pppoeAlwaysStayConnectedButton.addInfoRecord(theInfo.get("peAC"), "01");
        this.pppoeAlwaysStayConnectedButton.addInfoRecord(theInfo.get("peID"), "0");
        this.pppoeAutomaticConnectButton = new AirportInfoRadioButton("Connect automatically");
        this.pppoeAutomaticConnectButton.addInfoRecord(theInfo.get("peAC"), "01");
        this.pppoeAutomaticConnectButton.addInfoRecord(theInfo.get("peSC"), "00");
        this.pppoeManualConnectButton = new AirportInfoRadioButton("Don't connect automatically");
        this.pppoeManualConnectButton.addInfoRecord(theInfo.get("peAC"), "00");
        this.pppoeManualConnectButton.addInfoRecord(theInfo.get("peSC"), "00");
        this.connectionGroup = new ButtonGroup();
        this.connectionGroup.add(this.pppoeAlwaysStayConnectedButton);
        this.connectionGroup.add(this.pppoeAutomaticConnectButton);
        this.connectionGroup.add(this.pppoeManualConnectButton);
        this.pppoeDisconnectTimeoutField = new AirportInfoLabelledScaledValueField("PPPoE idle timeout (minutes; 0 = never)", theInfo.get("peID"), 60);
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(1, 1, 1, 1);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        this.loginButton = new JButton("Username/Password");
        this.loginButton.setActionCommand("show login panel");
        this.loginButton.addActionListener(this);
        this.pppoeDisconnectTimeoutPanel = new AirportInfoPanel();
        this.pppoeDisconnectTimeoutPanel.add(this.pppoeDisconnectTimeoutField);
        this.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        theLayout.setConstraints(this.pppoeAlwaysStayConnectedButton, c);
        this.add(this.pppoeAlwaysStayConnectedButton);
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.pppoeAutomaticConnectButton, c);
        this.add(this.pppoeAutomaticConnectButton);
        c.gridx = 1;
        c.gridy = 4;
        theLayout.setConstraints(this.pppoeManualConnectButton, c);
        this.add(this.pppoeManualConnectButton);
        c.gridx = 2;
        c.gridy = 2;
        c.gridheight = 3;
        c.anchor = 10;
        theLayout.setConstraints(this.loginButton, c);
        this.add(this.loginButton);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.anchor = 17;
        theLayout.setConstraints(this.pppoeDisconnectTimeoutPanel, c);
        this.add(this.pppoeDisconnectTimeoutPanel);
        this.pppoeAutomaticConnectButton.addItemListener(this.pppoeDisconnectTimeoutPanel);
        this.pppoeManualConnectButton.addItemListener(this.pppoeDisconnectTimeoutPanel);
        this.pppoeDisconnectTimeoutPanel.setEnabled(this.pppoeAutomaticConnectButton.isSelected() || this.pppoeManualConnectButton.isSelected());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.pppoeDisconnectTimeoutPanel.setEnabled(this.pppoeAutomaticConnectButton.isSelected() || this.pppoeManualConnectButton.isSelected());
        }
    }

    public void actionPerformed(ActionEvent theEvent) {
        String command = theEvent.getActionCommand();
        if (command.equals("show login panel")) {
            Container owner = this;
            while (owner != null && !(owner instanceof Frame)) {
                owner = owner.getParent();
            }
            Frame owningFrame = (Frame)owner;
            AirportPPPoELoginInfoDialog loginDialog = new AirportPPPoELoginInfoDialog(owningFrame, "PPPoE Login Information", true, this.theInfo);
            loginDialog.pack();
            Dimension dim = loginDialog.getSize();
            dim.height += 20;
            dim.width += 20;
            ((Component)loginDialog).setSize(dim);
            loginDialog.show();
        }
    }
}

