/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class AirportInfo
extends Hashtable {
    public static final int MAX_NUM_MAC_ADDRESSES = 256;
    public static final int MAX_NUM_PORT_MAPS = 20;
    public static final int MAX_NUM_SNMP_ACCESS_ENTRIES = 5;
    public static final int MAX_NUM_LOGIN_CHARS = 127;

    public AirportInfo() {
        this.initializeHashtable();
    }

    public AirportInfo(byte[] retrievedBytes) throws IllegalArgumentException {
        int count = 0;
        byte[] invalidBytes = new byte[]{-1, -1, -1, -10};
        ByteArrayInputStream byteStream = new ByteArrayInputStream(retrievedBytes);
        this.initializeHashtable();
        while (byteStream.available() > 0) {
            byte[] valueBytes;
            int length;
            byte[] lengthBytes;
            byte[] encryptionBytes;
            byte[] tagBytes = new byte[4];
            byteStream.read(tagBytes, 0, 4);
            String tag = new String(tagBytes);
            if (tag.equals("\u0000\u0000\u0000\u0000")) break;
            AirportInfoRecord element = this.get(tag);
            ++count;
            if (element != null) {
                encryptionBytes = new byte[4];
                byteStream.read(encryptionBytes, 0, 4);
                element.encryption = this.getIntegerValue(encryptionBytes);
                lengthBytes = new byte[4];
                byteStream.read(lengthBytes, 0, 4);
                length = this.getIntegerValue(lengthBytes);
                valueBytes = new byte[length];
                byteStream.read(valueBytes, 0, length);
                if (element.encryption == 2) {
                    valueBytes = AirportInfoRecord.decryptBytes(AirportInfoRecord.cipherBytes, valueBytes);
                }
                if (AirportInfo.arraysEqual(valueBytes, invalidBytes) && element.dataType != 1) continue;
                element.value = valueBytes;
                continue;
            }
            element = new AirportInfoRecord();
            element.tag = tag;
            encryptionBytes = new byte[4];
            byteStream.read(encryptionBytes, 0, 4);
            element.encryption = this.getIntegerValue(encryptionBytes);
            lengthBytes = new byte[4];
            byteStream.read(lengthBytes, 0, 4);
            element.maxLength = length = this.getIntegerValue(lengthBytes);
            valueBytes = new byte[length];
            byteStream.read(valueBytes, 0, length);
            if (element.encryption == 2) {
                valueBytes = AirportInfoRecord.decryptBytes(AirportInfoRecord.cipherBytes, valueBytes);
            }
            element.value = !AirportInfo.arraysEqual(valueBytes, invalidBytes) || element.dataType == 1 ? valueBytes : new byte[element.maxLength];
            this.put(tag, element);
        }
        if (count == 0) {
            throw new IllegalArgumentException("No information retrieved from base station!");
        }
    }

    private void initializeHashtable() {
        int maxSize = 32;
        int dataType = 0;
        int encryption = 2;
        String description = "Read community";
        String tag = "syPR";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Read/write community";
        tag = "syPW";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 2;
        encryption = 0;
        description = "Configuration mode";
        tag = "waCV";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 2;
        encryption = 0;
        description = "Ethernet/Modem switch 1";
        tag = "waIn";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Microwave robustness flag";
        tag = "raRo";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Closed network flag";
        tag = "raCl";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 2;
        encryption = 0;
        description = "Access point density";
        tag = "raDe";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 2;
        encryption = 0;
        description = "Multicast rate";
        tag = "raMu";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 0;
        description = "Wireless channel";
        tag = "raCh";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 0;
        description = "Modem timeout";
        tag = "moID";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Dialing type (tone or pulse)";
        tag = "moPD";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Automatic dial";
        tag = "moAD";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 0;
        description = "Phone country code";
        tag = "moCC";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 0;
        description = "Modem country code combo box index";
        tag = "moCI";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Network name";
        tag = "raNm";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Primary phone number";
        tag = "moPN";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Secondary phone number";
        tag = "moAP";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 0;
        description = "PPPoE idle timeout";
        tag = "peID";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "PPPoE auto connect";
        tag = "peAC";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "PPPoE stay connected";
        tag = "peSC";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 2;
        encryption = 0;
        description = "Encryption switch";
        tag = "raWM";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 13;
        dataType = 2;
        encryption = 2;
        description = "Encryption key";
        tag = "raWE";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Private LAN base station address";
        tag = "laIP";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Private LAN subnet mask";
        tag = "laSM";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Wireless to Ethernet bridging switch";
        tag = "raWB";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "Access control switch";
        tag = "acEn";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 16;
        dataType = 2;
        encryption = 2;
        description = "Access control info";
        tag = "acTa";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 2;
        description = "Wireless DHCP switch";
        tag = "raDS";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "LAN Ethernet DHCP switch";
        tag = "laDS";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 2;
        description = "WAN Ethernet DHCP switch";
        tag = "waDS";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 1;
        dataType = 5;
        encryption = 0;
        description = "NAT switch";
        tag = "raNA";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Base station IP address";
        tag = "waIP";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Router IP address";
        tag = "waRA";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Subnet mask";
        tag = "waSM";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Contact person name";
        tag = "syCt";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Base station name";
        tag = "syNm";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Base station location";
        tag = "syLo";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "DHCP client ID";
        tag = "waDC";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "DHCP address range start";
        tag = "dhBg";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "DHCP address range end";
        tag = "dhEn";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Primary DNS server";
        tag = "waD1";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 1;
        encryption = 2;
        description = "Secondary DNS server";
        tag = "waD2";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 4;
        dataType = 4;
        encryption = 2;
        description = "DHCP lease time";
        tag = "dhLe";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 32;
        dataType = 0;
        encryption = 2;
        description = "Domain name";
        tag = "waDN";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 16;
        dataType = 2;
        encryption = 2;
        description = "Port mapping";
        tag = "pmTa";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 64;
        dataType = 0;
        encryption = 2;
        description = "Dial-up username";
        tag = "moUN";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 64;
        dataType = 0;
        encryption = 2;
        description = "Dial-up password";
        tag = "moPW";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 64;
        dataType = 0;
        encryption = 2;
        description = "PPPoE username";
        tag = "peUN";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 64;
        dataType = 0;
        encryption = 2;
        description = "PPPoE password";
        tag = "pePW";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 64;
        dataType = 0;
        encryption = 2;
        description = "PPPoE service name";
        tag = "peSN";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
        maxSize = 0;
        dataType = 5;
        encryption = 0;
        description = "Reboot flag";
        tag = "acRB";
        this.put(tag, new AirportInfoRecord(tag, description, dataType, encryption, maxSize));
    }

    public AirportInfoRecord get(String name) {
        return (AirportInfoRecord)super.get(name);
    }

    public byte[] getUpdateBytes() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Enumeration elementEnumeration = this.elements();
        while (elementEnumeration.hasMoreElements()) {
            AirportInfoRecord nextElement = (AirportInfoRecord)elementEnumeration.nextElement();
            try {
                outStream.write(nextElement.getUpdateBytes());
            }
            catch (IOException iOException) {}
        }
        return outStream.toByteArray();
    }

    public byte[] getRequestBytes() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Enumeration elementEnumeration = this.elements();
        while (elementEnumeration.hasMoreElements()) {
            AirportInfoRecord nextElement = (AirportInfoRecord)elementEnumeration.nextElement();
            try {
                outStream.write(nextElement.getRequestBytes());
            }
            catch (IOException iOException) {}
        }
        return outStream.toByteArray();
    }

    public String toString() {
        String returnText = new String();
        Enumeration elementEnumeration = this.elements();
        while (elementEnumeration.hasMoreElements()) {
            AirportInfoRecord theElement = (AirportInfoRecord)elementEnumeration.nextElement();
            returnText = String.valueOf(returnText) + theElement.toString();
            returnText = String.valueOf(returnText) + "\n";
        }
        return returnText;
    }

    private int getIntegerValue(byte[] valueBytes) {
        int value = 0;
        int i = 0;
        while (i < valueBytes.length) {
            int absValue = valueBytes[i];
            if (absValue < 0) {
                absValue += 256;
            }
            value = value * 256 + absValue;
            ++i;
        }
        return value;
    }

    private static boolean arraysEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

