/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportEthernetConfigPanel;
import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportInfoTextField;
import airport.AirportModemConfigPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;

public class AirportNetworkPanel
extends AirportInfoPanel
implements ItemListener {
    private AirportInfoRadioButton modemButton = new AirportInfoRadioButton("Connect to network through modem");
    private AirportInfoRadioButton ethernetButton;
    private AirportInfoTextField primaryDNSField;
    private AirportInfoTextField secondaryDNSField;
    private AirportInfoTextField domainNameField;
    private AirportInfoPanel ethernetConfigPanel;
    private AirportInfoPanel modemConfigPanel;
    private AirportInfoPanel dnsPanel;
    private ButtonGroup modemEthernetButtonGroup;

    public AirportNetworkPanel(AirportInfo airportInfo) {
        this.modemButton.addInfoRecord(airportInfo.get("Ethernet/Modem switch 1"), "62");
        this.modemButton.addInfoRecord(airportInfo.get("Configuration interface"), "03");
        this.modemButton.addInfoRecord(airportInfo.get("Base station configuration mode switch"), "00");
        this.ethernetButton = new AirportInfoRadioButton("Connect to network through Ethernet port");
        this.ethernetButton.addInfoRecord(airportInfo.get("Ethernet/Modem switch 1"), "60");
        this.modemEthernetButtonGroup = new ButtonGroup();
        this.modemEthernetButtonGroup.add(this.modemButton);
        this.modemEthernetButtonGroup.add(this.ethernetButton);
        this.primaryDNSField = new AirportInfoTextField(airportInfo.get("Primary DNS server"));
        this.secondaryDNSField = new AirportInfoTextField(airportInfo.get("Secondary DNS server"));
        this.domainNameField = new AirportInfoTextField(airportInfo.get("Domain name"));
        this.ethernetConfigPanel = new AirportEthernetConfigPanel(airportInfo);
        this.modemConfigPanel = new AirportModemConfigPanel(airportInfo);
        this.setUpDisplay();
    }

    public void setUpDisplay() {
        Insets insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.dnsPanel = new AirportInfoPanel();
        this.dnsPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel("Primary DNS server IP address");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.dnsPanel.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.primaryDNSField, gridBagConstraints);
        this.dnsPanel.add(this.primaryDNSField);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Secondary DNS server IP address");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.dnsPanel.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.secondaryDNSField, gridBagConstraints);
        this.dnsPanel.add(this.secondaryDNSField);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jLabel = new JLabel("Domain name");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.dnsPanel.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.domainNameField, gridBagConstraints);
        this.dnsPanel.add(this.domainNameField);
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.ethernetButton, gridBagConstraints);
        this.add(this.ethernetButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.modemButton, gridBagConstraints);
        this.add(this.modemButton);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.ethernetConfigPanel, gridBagConstraints);
        this.add(this.ethernetConfigPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.modemConfigPanel, gridBagConstraints);
        this.add(this.modemConfigPanel);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.dnsPanel, gridBagConstraints);
        this.add(this.dnsPanel);
        this.modemButton.addItemListener(this.modemConfigPanel);
        this.modemButton.addItemListener(this);
        this.modemConfigPanel.setEnabled(this.modemButton.isSelected());
        this.modemConfigPanel.setVisible(this.modemButton.isSelected());
        this.ethernetButton.addItemListener(this.ethernetConfigPanel);
        this.ethernetButton.addItemListener(this);
        this.ethernetConfigPanel.setEnabled(this.ethernetButton.isSelected());
        this.ethernetConfigPanel.setVisible(this.ethernetButton.isSelected());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.modemConfigPanel.setVisible(this.modemButton.isSelected());
        this.ethernetConfigPanel.setVisible(this.ethernetButton.isSelected());
    }
}

