/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPInteger;
import snmp.SNMPMessage;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPPDU;
import snmp.SNMPSequence;
import snmp.SNMPSetException;
import snmp.SNMPVarBindList;
import snmp.SNMPVariablePair;

public class SNMPv1CommunicationInterface {
    public static final int SNMPPORT = 161;
    public static final int MAXSIZE = 512;
    private int version;
    private InetAddress hostAddress;
    private String community;
    DatagramSocket dSocket;
    public int requestID = 1;

    public SNMPv1CommunicationInterface(int n, InetAddress inetAddress, String string) throws SocketException {
        this.version = n;
        this.hostAddress = inetAddress;
        this.community = string;
        this.dSocket = new DatagramSocket();
        this.dSocket.setSoTimeout(15000);
    }

    public void setSocketTimeout(int n) throws SocketException {
        this.dSocket.setSoTimeout(n);
    }

    public void closeConnection() throws SocketException {
        this.dSocket.close();
    }

    public SNMPVarBindList retrieveAllMIBInfo(String string) throws IOException, SNMPBadValueException {
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence = new SNMPSequence();
        sNMPSequence.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 161);
        this.dSocket.send(datagramPacket);
        while (n == 0) {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            sNMPSequence = sNMPMessage2.getPDU().getVarBindList();
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(0);
            SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence2.getSNMPObjectAt(1);
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
            if (sNMPObjectIdentifier.equals(sNMPObjectIdentifier2)) break;
            sNMPObjectIdentifier = sNMPObjectIdentifier2;
            ++this.requestID;
            sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
            sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
            byArray = sNMPMessage.getBEREncoding();
            datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 161);
            this.dSocket.send(datagramPacket);
        }
        return sNMPVarBindList;
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = String.valueOf(string) + Integer.toHexString(n2 / 16);
        string = String.valueOf(string) + Integer.toHexString(n2 % 16);
        return string;
    }

    public SNMPVarBindList getMIBEntry(String string) throws IOException, SNMPBadValueException, SNMPGetException {
        SNMPSequence sNMPSequence;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        sNMPSequence2.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-96, this.requestID, n, n2, sNMPSequence2);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 161);
        this.dSocket.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
        while (true) {
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage2.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) {
                throw new SNMPGetException("OID " + string + " not available for retrieval");
            }
            sNMPSequence2 = sNMPPDU2.getVarBindList();
            sNMPSequence = (SNMPSequence)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
            if (sNMPObjectIdentifier2.toString().equals(string)) break;
        }
        sNMPVarBindList.addSNMPObject(sNMPSequence);
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList getNextMIBEntry(String string) throws IOException, SNMPBadValueException, SNMPGetException {
        byte[] byArray;
        SNMPMessage sNMPMessage;
        SNMPPDU sNMPPDU;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence = new SNMPSequence();
        sNMPSequence.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU2 = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
        SNMPMessage sNMPMessage2 = new SNMPMessage(this.version, this.community, sNMPPDU2);
        byte[] byArray2 = sNMPMessage2.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, this.hostAddress, 161);
        this.dSocket.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
        do {
            this.dSocket.receive(datagramPacket2);
            byArray = datagramPacket2.getData();
        } while ((sNMPPDU = (sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value)).getPDU()).getRequestID() != this.requestID);
        if (sNMPPDU.getErrorStatus() != 0) {
            throw new SNMPGetException("OID " + string + " not available for retrieval");
        }
        sNMPSequence = sNMPPDU.getVarBindList();
        SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(0);
        SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
        SNMPObject sNMPObject = sNMPSequence2.getSNMPObjectAt(1);
        sNMPVarBindList.addSNMPObject(sNMPSequence2);
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList setMIBEntry(String string, SNMPObject sNMPObject) throws IOException, SNMPBadValueException, SNMPSetException {
        SNMPSequence sNMPSequence;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, sNMPObject);
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        sNMPSequence2.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-93, this.requestID, n, n2, sNMPSequence2);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 161);
        this.dSocket.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
        while (true) {
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage2.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) {
                switch (sNMPPDU2.getErrorStatus()) {
                    case 1: {
                        throw new SNMPSetException("Value supplied for OID " + string + " too big.");
                    }
                    case 2: {
                        throw new SNMPSetException("OID " + string + " not available for setting.");
                    }
                    case 3: {
                        throw new SNMPSetException("Bad value supplied for OID " + string + ".");
                    }
                    case 4: {
                        throw new SNMPSetException("OID " + string + " read-only.");
                    }
                }
                throw new SNMPSetException("Error setting OID " + string + ".");
            }
            sNMPSequence2 = sNMPPDU2.getVarBindList();
            sNMPSequence = (SNMPSequence)sNMPSequence2.getSNMPObjectAt(0);
            if (((SNMPObjectIdentifier)sNMPSequence.getSNMPObjectAt(0)).toString().equals(string)) break;
        }
        sNMPVarBindList.addSNMPObject(sNMPSequence);
        ++this.requestID;
        return sNMPVarBindList;
    }
}

