/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.object.Curve;
import artofillusion.object.ObjectInfo;
import artofillusion.tools.ArraySpec;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ArrayDialog
extends Dialog
implements ActionListener,
ItemListener,
TextListener {
    private LayoutWindow window;
    private ArraySpec spec;
    private Vector curvesVector;
    private Button okButton;
    private Button cancelButton;
    private Label linearCopiesLabel;
    private Label stepXLabel;
    private Label stepYLabel;
    private Label stepZLabel;
    private Checkbox curveCopiesBox;
    private Checkbox curveStepBox;
    private Checkbox linearBox;
    private Checkbox intervalXBox;
    private Checkbox intervalYBox;
    private Checkbox intervalZBox;
    private Checkbox curveBox;
    private Checkbox orientationBox;
    private Checkbox useOrientationBox;
    private Checkbox useOriginBox;
    private Checkbox duplicateBox;
    private Checkbox groupBox;
    private Checkbox liveBox;
    private Checkbox deepBox;
    private Choice curveChoice;
    private ValueField linearCopiesField;
    private ValueField stepXField;
    private ValueField stepYField;
    private ValueField stepZField;
    private ValueField curveCopiesField;
    private ValueField curveStepField;
    private CheckboxGroup methodGroup;
    private CheckboxGroup modeGroup;

    public ArrayDialog(LayoutWindow window) {
        super((Frame)window, "Array", true);
        this.window = window;
        this.spec = new ArraySpec(window);
        this.curvesVector = new Vector(10, 10);
        int i = 0;
        while (i < window.getScene().getNumObjects()) {
            ObjectInfo info = window.getScene().getObject(i);
            if (info.object instanceof Curve) {
                this.curvesVector.addElement(info);
            }
            ++i;
        }
        this.methodGroup = new CheckboxGroup();
        this.modeGroup = new CheckboxGroup();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 10;
        gc.fill = 0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)new Label("Create Array of Selected Objects:"), gc);
        gc.insets.top = 15;
        gc.gridx = 0;
        gc.gridy = 1;
        this.add((Component)this.createLinearPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.add((Component)this.createCurvePanel(), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.add((Component)this.createOptionsPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.anchor = 10;
        gc.ipady = 0;
        this.add((Component)this.createFinishPanel(), gc);
        if (this.curvesVector.size() <= 0) {
            this.curveBox.setEnabled(false);
        }
        this.updateSpec();
        this.pack();
        this.show();
    }

    private Panel createLinearPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        this.linearBox = new Checkbox("Linear:", this.spec.method == 0, this.methodGroup);
        panel.add((Component)this.linearBox, gc);
        this.linearBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.insets.left = 5;
        this.linearCopiesLabel = new Label("Number of Copies");
        panel.add((Component)this.linearCopiesLabel, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.linearCopiesField = new ValueField((float)this.spec.linearCopies, 7, 4);
        panel.add((Component)this.linearCopiesField, gc);
        this.linearCopiesField.addTextListener((TextListener)this);
        gc.gridx = 1;
        gc.gridy = 1;
        this.stepXLabel = new Label("Step X:");
        panel.add((Component)this.stepXLabel, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        this.stepXField = new ValueField(this.spec.stepX, 0, 4);
        panel.add((Component)this.stepXField, gc);
        this.stepXField.addTextListener((TextListener)this);
        gc.gridx = 3;
        gc.gridy = 1;
        this.intervalXBox = new Checkbox("Times X Size", this.spec.intervalX);
        panel.add((Component)this.intervalXBox, gc);
        this.intervalXBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 2;
        this.stepYLabel = new Label("Step Y:");
        panel.add((Component)this.stepYLabel, gc);
        gc.gridx = 2;
        gc.gridy = 2;
        this.stepYField = new ValueField(this.spec.stepY, 0, 4);
        panel.add((Component)this.stepYField, gc);
        this.stepYField.addTextListener((TextListener)this);
        gc.gridx = 3;
        gc.gridy = 2;
        this.intervalYBox = new Checkbox("Times Y Size", this.spec.intervalY);
        panel.add((Component)this.intervalYBox, gc);
        this.intervalYBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 3;
        this.stepZLabel = new Label("Step Z:");
        panel.add((Component)this.stepZLabel, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        this.stepZField = new ValueField(this.spec.stepZ, 0, 4);
        panel.add((Component)this.stepZField, gc);
        this.stepZField.addTextListener((TextListener)this);
        gc.gridx = 3;
        gc.gridy = 3;
        this.intervalZBox = new Checkbox("Times Z Size", this.spec.intervalZ);
        panel.add((Component)this.intervalZBox, gc);
        this.intervalZBox.addItemListener(this);
        return panel;
    }

    private Panel createCurvePanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        this.curveBox = new Checkbox("From Curve", this.spec.method == 1, this.methodGroup);
        panel.add((Component)this.curveBox, gc);
        this.curveBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.insets.left = 5;
        this.curveChoice = new Choice();
        panel.add((Component)this.curveChoice, gc);
        int k = 0;
        while (k < this.curvesVector.size()) {
            ObjectInfo info = (ObjectInfo)this.curvesVector.elementAt(k);
            this.curveChoice.add(info.name);
            ++k;
        }
        if (this.spec.curve != null) {
            this.curveChoice.select(this.spec.curve.name);
        }
        this.curveChoice.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 1;
        this.curveCopiesBox = new Checkbox("Number Of Copies", this.spec.curveMode == 1, this.modeGroup);
        panel.add((Component)this.curveCopiesBox, gc);
        this.curveCopiesBox.addItemListener(this);
        gc.gridx = 2;
        gc.gridy = 1;
        this.curveCopiesField = new ValueField((float)this.spec.curveCopies, 7, 4);
        panel.add((Component)this.curveCopiesField, gc);
        this.curveCopiesField.addTextListener((TextListener)this);
        gc.gridx = 1;
        gc.gridy = 2;
        this.curveStepBox = new Checkbox("Step Size:", this.spec.curveMode == 0, this.modeGroup);
        panel.add((Component)this.curveStepBox, gc);
        this.curveStepBox.addItemListener(this);
        gc.gridx = 2;
        gc.gridy = 2;
        this.curveStepField = new ValueField(this.spec.curveStep, 3, 4);
        panel.add((Component)this.curveStepField, gc);
        this.curveStepField.addTextListener((TextListener)this);
        gc.gridx = 1;
        gc.gridy = 3;
        this.orientationBox = new Checkbox("Orientation Follows Curve", this.spec.orientation);
        panel.add((Component)this.orientationBox, gc);
        this.orientationBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 4;
        this.useOriginBox = new Checkbox("Use Original Position", !this.spec.ignoreOrigin);
        panel.add((Component)this.useOriginBox, gc);
        this.useOriginBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 5;
        this.useOrientationBox = new Checkbox("Use Original Orientation", !this.spec.ignoreOrientation);
        panel.add((Component)this.useOrientationBox, gc);
        this.useOrientationBox.addItemListener(this);
        return panel;
    }

    private Panel createOptionsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        this.deepBox = new Checkbox("Include Children", this.spec.deep);
        panel.add((Component)this.deepBox, gc);
        this.deepBox.addItemListener(this);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        this.groupBox = new Checkbox("Group", this.spec.group);
        panel.add((Component)this.groupBox, gc);
        this.groupBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.insets.left = 5;
        this.duplicateBox = new Checkbox("Skip First Copy", !this.spec.dupFirst);
        panel.add((Component)this.duplicateBox, gc);
        this.duplicateBox.addItemListener(this);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        this.liveBox = new Checkbox("Live Duplicates", this.spec.live);
        panel.add((Component)this.liveBox, gc);
        this.liveBox.addItemListener(this);
        return panel;
    }

    private Panel createFinishPanel() {
        Panel panel = new Panel();
        this.okButton = Translate.button((String)"ok", (ActionListener)this);
        panel.add(this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (ActionListener)this);
        panel.add(this.cancelButton);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.updateSpec();
            this.spec.createArray();
            this.window.rebuildItemList();
            this.window.updateImage();
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateSpec();
    }

    public void textValueChanged(TextEvent e) {
        this.updateSpec();
    }

    private void updateSpec() {
        if (this.linearBox.getState()) {
            this.spec.method = 0;
        }
        if (this.curveBox.getState()) {
            this.spec.method = 1;
        }
        this.spec.linearCopies = (int)this.linearCopiesField.getValue();
        this.spec.stepX = this.stepXField.getValue();
        this.spec.stepY = this.stepYField.getValue();
        this.spec.stepZ = this.stepZField.getValue();
        this.spec.intervalX = this.intervalXBox.getState();
        this.spec.intervalY = this.intervalYBox.getState();
        this.spec.intervalZ = this.intervalZBox.getState();
        if (this.curvesVector.size() > 0) {
            this.spec.curve = (ObjectInfo)this.curvesVector.elementAt(this.curveChoice.getSelectedIndex());
        }
        if (this.curveCopiesBox.getState()) {
            this.spec.curveMode = 1;
        }
        if (this.curveStepBox.getState()) {
            this.spec.curveMode = 0;
        }
        this.spec.curveStep = this.curveStepField.getValue();
        this.spec.curveCopies = (int)this.curveCopiesField.getValue();
        this.spec.orientation = this.orientationBox.getState();
        this.spec.ignoreOrientation = !this.useOrientationBox.getState();
        this.spec.ignoreOrigin = !this.useOriginBox.getState();
        this.spec.dupFirst = !this.duplicateBox.getState();
        this.spec.group = this.groupBox.getState();
        this.spec.live = this.liveBox.getState();
        this.spec.deep = this.deepBox.getState();
        this.linearCopiesField.setEnabled(this.spec.method == 0);
        this.stepXField.setEnabled(this.spec.method == 0);
        this.stepYField.setEnabled(this.spec.method == 0);
        this.stepZField.setEnabled(this.spec.method == 0);
        this.linearCopiesLabel.setEnabled(this.spec.method == 0);
        this.stepXLabel.setEnabled(this.spec.method == 0);
        this.stepYLabel.setEnabled(this.spec.method == 0);
        this.stepZLabel.setEnabled(this.spec.method == 0);
        this.intervalXBox.setEnabled(this.spec.method == 0);
        this.intervalYBox.setEnabled(this.spec.method == 0);
        this.intervalZBox.setEnabled(this.spec.method == 0);
        this.curveChoice.setEnabled(this.spec.method == 1);
        this.curveCopiesField.setEnabled(this.spec.method == 1 & this.spec.curveMode == 1);
        this.curveCopiesBox.setEnabled(this.spec.method == 1);
        this.curveStepField.setEnabled(this.spec.method == 1 & this.spec.curveMode == 0);
        this.curveStepBox.setEnabled(this.spec.method == 1);
        this.orientationBox.setEnabled(this.spec.method == 1);
        this.useOriginBox.setEnabled(this.spec.method == 1);
        this.useOrientationBox.setEnabled(this.spec.method == 1);
    }
}

