/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.UndoRecord;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.SplineMesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class LatheDialog
extends Dialog
implements ActionListener,
AdjustmentListener,
ItemListener,
TextListener {
    LayoutWindow window;
    Curve theCurve;
    CheckboxGroup axisGroup;
    Checkbox xBox;
    Checkbox yBox;
    Checkbox zBox;
    Checkbox endsBox;
    ValueField radiusField;
    ValueField segmentsField;
    ValueSlider angleSlider;
    Button okButton;
    Button cancelButton;
    ObjectPreviewCanvas preview;
    private static int counter = 1;

    public LatheDialog(LayoutWindow window, Curve obj) {
        super((Frame)window, "Lathe", true);
        this.window = window;
        this.theCurve = obj;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridwidth = 2;
        this.add((Component)new Label("Select Lathe Axis:"), gc);
        this.axisGroup = new CheckboxGroup();
        this.xBox = new Checkbox("X axis", false, this.axisGroup);
        this.add((Component)this.xBox, gc);
        this.yBox = new Checkbox("Y axis", true, this.axisGroup);
        this.add((Component)this.yBox, gc);
        this.zBox = new Checkbox("Z axis", false, this.axisGroup);
        this.add((Component)this.zBox, gc);
        this.endsBox = new Checkbox("Line through endpoints", false, this.axisGroup);
        this.add((Component)this.endsBox, gc);
        this.xBox.addItemListener(this);
        this.yBox.addItemListener(this);
        this.zBox.addItemListener(this);
        this.endsBox.addItemListener(this);
        this.add((Component)new Label("Total Rotation Angle:"), gc);
        gc.fill = 2;
        this.angleSlider = new ValueSlider(0.0, 360.0, 180, 360.0);
        this.add((Component)this.angleSlider, gc);
        this.angleSlider.addAdjustmentListener((AdjustmentListener)this);
        gc.gridwidth = 1;
        this.add((Component)new Label("Radius:"), gc);
        this.add((Component)new Label("Segments:"), gc);
        gc.gridx = 1;
        this.radiusField = new ValueField(0.0, 0);
        this.add((Component)this.radiusField, gc);
        this.segmentsField = new ValueField(8.0, 7);
        this.add((Component)this.segmentsField, gc);
        this.radiusField.addTextListener((TextListener)this);
        this.segmentsField.addTextListener((TextListener)this);
        gc.gridx = 2;
        gc.gridwidth = 1;
        gc.gridheight = 9;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        this.preview = new ObjectPreviewCanvas(null);
        this.add((Component)this.preview, gc);
        this.preview.setPreferredSize(150, 150);
        Panel p = new Panel();
        this.okButton = Translate.button((String)"ok", (ActionListener)this);
        p.add(this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (ActionListener)this);
        p.add(this.cancelButton);
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 0;
        gc.anchor = 10;
        gc.fill = 0;
        this.add((Component)p, gc);
        this.selectDefaults();
        this.makeObject();
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        this.makeObject();
    }

    public void textValueChanged(TextEvent e) {
        this.makeObject();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.makeObject();
    }

    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.window.addObject(this.preview.getObject().object, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "Lathed Object " + counter++, null);
            this.window.setSelection(this.window.getScene().getNumObjects() - 1);
            this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
            this.window.updateImage();
        }
        this.dispose();
    }

    private void selectDefaults() {
        MeshVertex[] vert = this.theCurve.getVertices();
        if (!this.theCurve.isClosed() && vert[0].r.distance(vert[vert.length - 1].r) > 0.0) {
            this.axisGroup.setSelectedCheckbox(this.endsBox);
            return;
        }
        this.endsBox.setEnabled(false);
        double minx = Double.MAX_VALUE;
        int i = 0;
        while (i < vert.length) {
            if (vert[i].r.x < minx) {
                minx = vert[i].r.x;
            }
            ++i;
        }
        minx = Math.max(-minx, 0.0);
        this.radiusField.setValue(Math.ceil(minx));
    }

    private void makeObject() {
        int i;
        Vec3 radius;
        Vec3 axis;
        MeshVertex[] vert = this.theCurve.getVertices();
        Vec3 center = new Vec3();
        int segments = (int)this.segmentsField.getValue();
        double angle = this.angleSlider.getValue();
        double angleStep = angle * Math.PI / ((double)segments * 180.0);
        boolean closed = false;
        if (angle == 360.0) {
            closed = true;
        } else {
            ++segments;
        }
        if (this.axisGroup.getSelectedCheckbox() == this.xBox) {
            axis = Vec3.vx();
            radius = Vec3.vy();
        } else if (this.axisGroup.getSelectedCheckbox() == this.yBox) {
            axis = Vec3.vy();
            radius = Vec3.vx();
        } else if (this.axisGroup.getSelectedCheckbox() == this.zBox) {
            axis = Vec3.vz();
            radius = Vec3.vx();
        } else {
            axis = vert[0].r.minus(vert[vert.length - 1].r);
            axis.normalize();
            center.set(vert[0].r);
            radius = new Vec3();
            int i2 = 0;
            while (i2 < vert.length) {
                radius.add(vert[i2].r);
                ++i2;
            }
            radius.scale(1.0 / (double)vert.length);
            radius.subtract(center);
            radius.subtract(axis.times(axis.dot(center)));
            radius.normalize();
        }
        center.add(radius.times(-this.radiusField.getValue()));
        Vec3[][] v = new Vec3[segments][vert.length];
        Vec3 cm = new Vec3();
        CoordinateSystem coords = new CoordinateSystem(center, axis, radius);
        int i3 = 0;
        while (i3 < segments) {
            Mat4 m = coords.fromLocal().times(Mat4.zrotation((double)((double)i3 * angleStep))).times(coords.toLocal());
            int j = 0;
            while (j < vert.length) {
                v[i3][j] = m.times(vert[j].r);
                cm.add(v[i3][j]);
                ++j;
            }
            ++i3;
        }
        float[] usmooth = new float[segments];
        float[] vsmooth = new float[vert.length];
        float[] s = this.theCurve.getSmoothness();
        int i4 = 0;
        while (i4 < segments) {
            usmooth[i4] = 1.0f;
            ++i4;
        }
        int i5 = 0;
        while (i5 < s.length) {
            vsmooth[i5] = s[i5];
            ++i5;
        }
        int smoothMethod = this.theCurve.getSmoothingMethod();
        if (smoothMethod == 0) {
            i = 0;
            while (i < s.length) {
                vsmooth[i] = 0.0f;
                ++i;
            }
            smoothMethod = 3;
        } else {
            i = 0;
            while (i < s.length) {
                vsmooth[i] = s[i];
                ++i;
            }
        }
        cm.scale(1.0 / (double)(segments * vert.length));
        int i6 = 0;
        while (i6 < v.length) {
            int j = 0;
            while (j < v[i6].length) {
                v[i6][j].subtract(cm);
                ++j;
            }
            ++i6;
        }
        SplineMesh mesh = new SplineMesh(v, usmooth, vsmooth, smoothMethod, closed, this.theCurve.isClosed());
        mesh.setTexture(this.window.getScene().getDefaultTexture());
        mesh.setTextureMapping(mesh.getTexture().getDefaultMapping());
        mesh.makeRightSideOut();
        this.preview.setObject((Object3D)mesh);
        this.preview.updateImage();
        this.preview.repaint();
    }
}

