/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TubeDialog
extends Dialog
implements ActionListener,
ItemListener,
TextListener {
    LayoutWindow window;
    Curve theCurve;
    ObjectInfo curveInfo;
    Tube theTube;
    Button okButton;
    Button cancelButton;
    ValueField thicknessField;
    Choice endsChoice;
    ObjectPreviewCanvas preview;
    private static int counter = 1;

    public TubeDialog(LayoutWindow window, ObjectInfo curve) {
        super((Frame)window, "Tube", true);
        this.window = window;
        this.curveInfo = curve;
        this.theCurve = (Curve)curve.object;
        Scene scene = window.getScene();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        this.add((Component)new Label("Tube Width"), gc);
        this.add((Component)new Label("Cap Ends"), gc);
        gc.gridx = 1;
        gc.fill = 2;
        this.thicknessField = new ValueField(0.1, 3, 5);
        this.add((Component)this.thicknessField, gc);
        this.thicknessField.addTextListener((TextListener)this);
        this.endsChoice = new Choice();
        this.add((Component)this.endsChoice, gc);
        this.endsChoice.add("Open Ends");
        this.endsChoice.add("Flat Ends");
        this.endsChoice.setEnabled(!this.theCurve.isClosed());
        this.endsChoice.addItemListener(this);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.preview = new ObjectPreviewCanvas(null);
        this.add((Component)this.preview, gc);
        this.preview.setPreferredSize(150, 150);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        Panel p = new Panel();
        this.okButton = Translate.button((String)"ok", (ActionListener)this);
        p.add(this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (ActionListener)this);
        p.add(this.cancelButton);
        this.add((Component)p, gc);
        this.makeObject();
        this.pack();
        this.show();
    }

    public void textValueChanged(TextEvent e) {
        this.makeObject();
    }

    public void itemStateChanged(ItemEvent e) {
        this.makeObject();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.okButton == e.getSource()) {
            this.window.addObject((Object3D)this.theTube, this.curveInfo.coords.duplicate(), "Tube " + counter++, null);
            this.window.setSelection(this.window.getScene().getNumObjects() - 1);
            this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
            this.window.updateImage();
            this.dispose();
        } else {
            this.dispose();
        }
    }

    private void makeObject() {
        MeshVertex[] vert = this.theCurve.getVertices();
        double[] thickness = new double[vert.length];
        int i = 0;
        while (i < thickness.length) {
            thickness[i] = this.thicknessField.getValue();
            ++i;
        }
        int endsStyle = this.theCurve.isClosed() ? 1 : (this.endsChoice.getSelectedIndex() == 0 ? 0 : 2);
        this.theTube = new Tube(this.theCurve, thickness, endsStyle);
        this.theTube.setTexture(this.window.getScene().getDefaultTexture());
        this.theTube.setTextureMapping(this.theTube.getTexture().getDefaultMapping());
        this.preview.setObject((Object3D)this.theTube);
        this.preview.updateImage();
        this.preview.repaint();
    }
}

